package com.clx.performance.param.feign.transport;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 法人货主同步
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
public class OwnerLegalSyncParam implements Serializable {

    @Schema(description = " 法人姓名 ", required = true)
    @NotBlank(message = "货主登录手机号不可为空")
    private String name;
    @Schema(description = " 货主手机号码 ", required = true)
    @NotBlank(message = "货主姓名不可为空")
    private String mobile;
    @Schema(description = " 身份证号 ", required = true)
    @NotBlank(message = "身份证号不可为空")
    private String cardNo;

    @Schema(description = " 企业名称 ", required = true)
    private String company;
    @Schema(description = " 注册时间 ", required = true)
    private String registerTime;

    @Schema(description = " 省 ", required = true)
    private String province;
    @Schema(description = " 省code ", required = true)
    private Integer provinceCode;
    @Schema(description = " 市 ", required = true)
    private String city;
    @Schema(description = " 市code ", required = true)
    private Integer cityCode;
    @Schema(description = " 区县 ", required = true)
    private String county;
    @Schema(description = " 区县code ", required = true)
    private Integer countyCode;
    @Schema(description = " 乡镇 ", required = true)
    private String town;
    @Schema(description = " 乡镇code ", required = true)
    private Integer townCode;
    @Schema(description = " 街道 ", required = true)
    private String street;
    @Schema(description = " 街道code ", required = true)
    private Integer streetCode;
    @Schema(description = " 详细地址 ", required = true)
    private String address;

    @Schema(description = " 申请类型:1法人认证2代理人认证 ", required = true)
    private Integer applyType;
    @Schema(description = " 法人姓名 ")
    private String legalName;
    @Schema(description = " 法人手机号 ")
    private String legalMobile;
    @Schema(description = " 法人身份证号 ")
    private String legalCardNo;
    @Schema(description = " 法人身份证正面图片地址 ")
    private String legalFrontImg;
    @Schema(description = " 法人身份证背面图片地址 ")
    private String legalBackImg;
    @Schema(description = " 法人统一社会信用代码 ")
    private String legalGroupCode;
    @Schema(description = " 法人营业执照图片地址 ")
    private String legalBusinessImg;

    @Schema(description = " 代理人姓名 ")
    private String agentName;
    @Schema(description = " 代理人手机号 ")
    private String agentMobile;
    @Schema(description = " 代理人身份证号 ")
    private String agentCardNo;
    @Schema(description = " 代理人身份证正面图片地址 ")
    private String agentFrontImg;
    @Schema(description = " 代理人身份证背面图片地址 ")
    private String agentBackImg;
    @Schema(description = " 代理人统一社会信用代码 ")
    private String agentGroupCode;
    @Schema(description = " 代理人授权书图片地址 ")
    private String agentBusinessImg;

    @Schema(description = " 企业联系人姓名 ", required = true)
    private String businessName;
    @Schema(description = " 企业联系人手机号 ", required = true)
    private String businessMobile;
    @Schema(description = " 企业类型 ", required = true)
    private Integer businessType;

    @Schema(description = " 注册机构名称 ")
    private String registerOrgName;
    @Schema(description = " 注册资本（单位：万元） ")
    private Double registerAmount;
    @Schema(description = " 组织机构代码 ")
    private String orgGroupCode;
    @Schema(description = " 企业邮箱 ")
    private String businessEmail;
    @Schema(description = " 核准时间 ")
    private String checkTime;

}
