package com.clx.performance.param.feign.transport;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OrderChildDriverInfoDTO {

//    @Schema(description = "运单号", required = true)
//    private String childNo;
//    @Schema(description = "司机ID", required = true)
//    private Integer driverId;

    @Schema(description = "手机号", required = true)
    @NotBlank(message = "手机号不能为空")
    private String mobile;
    @Schema(description = "姓名", required = true)
    @NotBlank(message = "姓名手机号不能为空")
    private String name;
    @Schema(description = "性别1男2女", required = true)
    private Integer sex;

//    @Schema(description = "头像相对地址", required = true)
//    private String headImg;
//    @Schema(description = "钱包账号", required = true)
//    private String walletCode;

    @Schema(description = "身份证号", required = true)
    @NotBlank(message = "身份证号不能为空")
    private String cardNo;
    @Schema(description = "身份证有效期起始时间", required = true)
    @NotBlank(message = "身份证有效期起始时间不能为空")
    private String cardStartTime;
    @Schema(description = "身份证有效期终止时间")
    private String cardEndTime;
    @Schema(description = "是否是长期 0-非长期 1-长期", required = true)
    @NotNull(message = "是否是长期不能为空")
    private Integer cardLongTerm;
    @Schema(description = "身份证正面图片地址", required = true)
    @NotBlank(message = "身份证正面图片地址不能为空")
    private String cardFrontImg;
    @Schema(description = "身份证背面图片地址", required = true)
    @NotBlank(message = "身份证背面图片地址不能为空")
    private String cardBackImg;
    @Schema(description = "手持身份证照片地址")
    private String faceCardImg;

    @Schema(description = "驾驶证号码", required = true)
//    @NotBlank(message = "驾驶证号码不能为空")
    private String licenceNo;
    @Schema(description = "初次领证日期", required = true)
//    @NotBlank(message = "初次领证日期不能为空")
    private String licenseTime;
    @Schema(description = "驾照类型", required = true)
//    @NotBlank(message = "驾照类型不能为空")
    private String licenceClass;
    @Schema(description = "驾驶证正面图片", required = true)
//    @NotBlank(message = "驾驶证正面图片不能为空")
    private String licenceImg;
    @Schema(description = "驾驶证背面图片", required = true)
//    @NotBlank(message = "驾驶证背面图片不能为空")
    private String licenceBackImg;
    @Schema(description = "驾驶证有效期起始时间", required = true)
//    @NotBlank(message = "驾驶证有效期起始时间不能为空")
    private String licenceStartTime;
    @Schema(description = "驾驶证有效期终止时间", required = true)
//    @NotBlank(message = "驾驶证有效期终止时间不能为空")
    private String licenceEndTime;

//    @Schema(description = "道路运输许可证图片地址", required = true)
//    @NotBlank(message = "道路运输许可证图片地址不能为空")
//    private String transportLicenceImg;

    @Schema(description = "道路运输从业资格证号", required = true)
//    @NotBlank(message = "道路运输从业资格证号不能为空")
    private String occupationalLicenceNo;
    @Schema(description = "道路运输从业资格证图片地址", required = true)
//    @NotBlank(message = "道路运输从业资格证图片地址不能为空")
    private String occupationalLicenceImg;
    @Schema(description = "从业资格证有效期起始时间", required = true)
//    @NotBlank(message = "从业资格证有效期起始时间不能为空")
    private String occupationalStartTime;
    @Schema(description = "从业资格证有效期终止时间", required = true)
//    @NotBlank(message = "从业资格证有效期终止时间不能为空")
    private String occupationalEndTime;

    @Schema(description = "驾驶证发证机关", required = true)
//    @NotBlank(message = "驾驶证发证机关不能为空")
    private String licenceIssueOrganization;
    @Schema(description = "身份证住址", required = true)
//    @NotBlank(message = "身份证住址不能为空")
    private String idCardAddress = "手动";

}
