package com.clx.performance.param.feign;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;


@Getter
@Setter
public class CancelOrderGoodsParam {
    @NotBlank(message = "订单编号不能为空")
    @Schema(description="订单编号")
    private String orderNo;

    @NotNull(message = "操作人编号不能为空")
    @Schema(description="操作人编号")
    private Long createBy;

    @NotNull(message = "操作人名称不能为空")
    @Size(max=32,message = "操作人名称最多输入32个字符")
    @Schema(description="操作人名称")
    private String createName;

    @NotNull(message = "调整货物吨数不能为空")
    @Schema(description="调前煤炭交易数（吨）")
    @DecimalMax(value = "999999999999.99",message = "调整货物吨数不能大于999999999999.99吨")
    private BigDecimal beforeWeight;

    @NotNull(message = "调整货物吨数不能为空")
    @Schema(description="调后煤炭交易数（吨）")
    @DecimalMax(value = "999999999999.99",message = "调整货物吨数不能大于999999999999.99吨")
    private BigDecimal afterWeight;

    @NotNull(message = "已挂单的吨数不能为空")
    @Schema(description="已挂单的吨数（吨）")
    @DecimalMax(value = "999999999999.99",message = "调整货物吨数不能大于999999999999.99吨")
    private BigDecimal orderedWeight;
}
