package com.clx.performance.param.app.collect;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

@Getter
@Setter
@NoArgsConstructor
public class CollectLineReportAbnormalSaveParam {

    @Schema(description = "上报类型：1:无法到达货源地 2:无法装货 3：无法到达目的地  4装车卸车异常", example = "")
    @NotNull(message = "上报类型不能为空")
    private Integer reportType;

    @Schema(description = "运单编号")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;

    @Schema(description = "无法到达货源地原因", example = "车辆问题")
    @NotBlank(message = "无法到达货源地原因不能为空")
    private String remark;


}
