package com.clx.performance.param.app;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;

@Getter
@Setter
@NoArgsConstructor
public class OrderChildCheckParam extends PositionParam {

    @Schema(description = "货单编号", example = "100000000")
    @NotBlank(message = "货单编号不能为空")
    private String orderGoodsNo;

    @Schema(description = "车辆id", example = "1")
    @NotNull(message = "车辆id空")
    private Integer truckId;

    @Schema(description = "车牌号", example = "1")
    @NotNull(message = "车牌号不能为空")
    private String truckNo;

    @Schema(description = "司机用户编号", example = "1")
    @NotNull(message = "司机用户编号空")
    private Long driverUserNo;

    @Schema(description="纬度")
    private BigDecimal latitude;

    @Schema(description="经度")
    private BigDecimal longitude;

    @Schema(description="可卸车时间段开始")
    private String unloadBeginTime;

    @Schema(description="可卸车时间段结束")
    private String unloadEndTime;

    @Schema(description="可装车时间段开始")
    private String loadBeginTime;

    @Schema(description="可装车时间段结束")
    private String loadEndTime;
}
