package com.clx.performance.enums.vehiclewarn;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum VehicleWarnChildEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum TraceStatus {
        DISABLE(0, "禁止"),
        ENABLE(1, "启用"),

        ;

        private final Integer code;
        private final String msg;
        public static Optional<TraceStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
        public static String getMsgByCode(int code) {
            return getByCode(code).map(TraceStatus::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum WarnStatus {
        DISABLE(0, "禁止"),
        ENABLE(1, "启用"),

        ;

        private final Integer code;
        private final String msg;
        public static Optional<WarnStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
        public static String getMsgByCode(int code) {
            return getByCode(code).map(WarnStatus::getMsg).orElse(null);
        }
    }

}
