package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

@Getter
@AllArgsConstructor
@SuppressWarnings("all")
public enum OwnerAccountEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum AccountTypeStatus {
        MARGIN_ACCOUNT(1, "保证金账户"),
        PREPAID_FREIGHT_ACCOUNT(2, "预付运费账户"),
        LOAN_ACCOUNT(3, "借款账户")
        ;
        private final Integer code;
        private final String msg;

        public static Optional<OwnerAccountEnum.AccountTypeStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }

        public Integer getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }
    }

    @Getter
    @AllArgsConstructor
    public enum TopUpStatus {
        PENDING(10, "待审批"),
        APPROVAL_REJECTION(20, "审批拒绝"),
        APPROVAL_APPROVE(30, "审批通过"),
        ;
        private final Integer code;
        private final String msg;

        public static Optional<OwnerAccountEnum.TopUpStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(OwnerAccountEnum.TopUpStatus::getMsg).orElse(null);
        }

    }

    @Getter
    @AllArgsConstructor
    public enum CaseOutStatus {
        PENDING_PAYMENT(10, "待付款"),
        TO_BE_CONFIRMED(20, "待货主确认"),
        PAID(30, "已付款"),
        ;
        private final Integer code;
        private final String msg;
        public String getMsg() {
            return this.msg;
        }

        public Integer getCode() {
            return this.code;
        }
    }

    @Getter
    @AllArgsConstructor
    public enum OrderChildTypeStatus {
        NETWORK(1, "网运单"),
        ORDINARY(2, "普通单"),
        ;
        private final Integer code;
        private final String msg;

        public Integer getCode() {
            return this.code;
        }
    }

    @Getter
    @AllArgsConstructor
    public enum RunningWaterStatus {
        TOP_UP(10, "充值"),
        FROZEN(20, "冻结"),
        THAW(30, "解冻"),
        CASE_OUT_FROZEN(40, "提现冻结"),
        CASE_OUT_SUCCESS(50, "提现成功"),
        TAKE_OUT(60, "扣款"),
        CASE_OUT_FAIL(70, "提现失败"),

        ;
        private final Integer code;
        private final String msg;
        public static Optional<OwnerAccountEnum.RunningWaterStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }

        public Integer getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }
    }
}
