package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum CarrierExceptionReportEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Status {

        //：1：待处理  2：申诉中  3：已处理  4：已撤回

        WAIT_DEAL(1, "待处理"),
        APPEAL_IN_PROGRESS(2, "申诉中"),
        PROCESSED(3, "已处理"),
        WITHDRAWN(4, "已撤回"),
        ;

        private final Integer code;
        private final String name;

        public static Optional<Status> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }
        public static String getMsgByCode(Integer code) {
            if (code == null) {return null;}
            return getByCode(code).map(Status::getName).orElse(null);
        }
    }


}
