package com.clx.performance.sqlProvider.loan;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanAccountParam;
import com.clx.performance.vo.pc.loan.carrier.CarrierOwnerLoanAccountVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

import java.util.Objects;

public class OwnerLoanAccountSqlProvider {

    public String getOwnerLoanAccountByOwnerUserId(@Param("param") Long ownerUserNo) {
        String sql = new SQL() {{
            SELECT("a.id, a.owner_user_no," +
                    " a.owner_user_name, a.mobile, a.account_type, " +
                    " a.funding_amount,a.virtually_amount,a.funding_arrears,a.virtually_arrears,a.create_by,date_format(a.create_time, '%Y-%m-%d %H:%i:%s') as create_time");
            FROM("owner_loan_account a");

            if (ObjectUtil.isNotNull(ownerUserNo)) {
                WHERE("a.owner_user_no = #{ownerUserNo}");
            }

            ORDER_BY("a.create_time desc");
        }}.toString();
        return sql;
    }

    public String pageByParam(@Param("page") Page<CarrierOwnerLoanAccountVO> page, @Param("param") PageOwnerLoanAccountParam param) {
        return new SQL(){{

            SELECT(" id, owner_user_no as ownerUserNo, owner_user_name as ownerUserName, mobile, " +
                    " account_type as accountType, " +
                    " funding_account_balance as fundingAccountBalance, funding_usable_balance as fundingUsableBalance, " +
                    " funding_frozen_balance as fundingFrozenBalance, virtually_account_balance as virtuallyAccountBalance, " +
                    " virtually_usable_balance as virtuallyUsableBalance, virtually_frozen_balance as virtuallyFrozenBalance, " +
                    " funding_arrears as fundingArrears, virtually_arrears as virtuallyArrears, " +
                    " create_by as createBy, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );

            FROM("owner_loan_account");

            if (Objects.nonNull(param.getOwnerUserNo())) {WHERE("owner_user_no = #{param.ownerUserNo}");}
            if (StringUtils.isNotBlank(param.getOwnerUserName())) {WHERE("owner_user_name like CONCAT(#{param.ownerUserName},'%')");}
            if (StringUtils.isNotBlank(param.getMobile())) {WHERE("mobile = #{param.mobile}");}

            ORDER_BY("create_time desc");
        }}.toString();
    }

}
