package com.clx.performance.sqlProvider.loan;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.loan.carrier.PageBorrowerConfigParam;
import com.clx.performance.vo.pc.loan.carrier.BorrowerConfigVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

import java.util.Objects;

public class BorrowerConfigSqlProvider {

    public String pageByParam(@Param("page") Page<BorrowerConfigVO> page, @Param("param") PageBorrowerConfigParam param) {
        return new SQL(){{

            SELECT(" id, borrower_id as borrowerId, borrower_name as borrowerName, " +
                    " type, day, " +
                    " delete_status as deleteStatus, status, " +
                    " op_user_no as opUserNo, op_user_name as opUserName, date_format(op_time, '%Y-%m-%d %H:%i:%s') as opTime, " +
                    " create_by as createBy, create_name as createName, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );

            FROM("borrower_config");
            WHERE("delete_status = 0");

            if (StringUtils.isNotBlank(param.getBorrowerName())) {WHERE("borrower_name like CONCAT(#{param.borrowerName},'%')");}
            if (Objects.nonNull(param.getStatus())) {WHERE("status = #{param.status}");}

            ORDER_BY("create_time desc");
        }}.toString();
    }

}
