package com.clx.performance.service.impl.vehiclewarn;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.vehiclewarn.VehicleWarnUserDao;
import com.clx.performance.enums.ResultEnum;
import com.clx.performance.enums.linewarn.LineWarnConfigEnum;
import com.clx.performance.enums.vehiclewarn.VehicleWarnConfigEnum;
import com.clx.performance.enums.vehiclewarn.VehicleWarnUserEnum;
import com.clx.performance.model.vehiclewarn.VehicleWarnUser;
import com.clx.performance.param.pc.vehiclewarn.*;
import com.clx.performance.service.vehiclewarn.VehicleWarnUserService;
import com.clx.performance.struct.vehiclewarn.VehicleWarnUserStruct;
import com.clx.performance.vo.pc.vehiclewarn.VehicleWarnUserVO;
import com.msl.common.base.Optional;
import com.msl.common.exception.ServiceSystemException;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Slf4j
@Service
public class VehicleWarnUserServiceImpl implements VehicleWarnUserService {

    @Autowired
    private VehicleWarnUserDao  vehicleWarnUserDao;

    @Autowired
    private VehicleWarnUserStruct vehicleWarnUserStruct;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveUser(VehicleWarnUserAddParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();

        Optional<VehicleWarnUser> optional = vehicleWarnUserDao.findByMobile(param.getMobile());
        if (optional.isPresent()){
            throw new ServiceSystemException(ResultEnum.VEHICLE_WARN_USER_EXIST);
        }

        List<Integer> warnTypeList = Arrays.stream(VehicleWarnConfigEnum.WarnType.values())
                .map(item -> item.getCode()).collect(Collectors.toList());
        List<Integer> lineWarnTypeList = Arrays.stream(LineWarnConfigEnum.WarnType.values())
                .map(item -> item.getCode()).collect(Collectors.toList());

        VehicleWarnUser vehicleWarnUser = new VehicleWarnUser();
        vehicleWarnUser.setName(param.getName());
        vehicleWarnUser.setMobile(param.getMobile());
        vehicleWarnUser.setOrderWarnTypeJson(JSON.toJSONString(new ArrayList<>()));
        vehicleWarnUser.setWarnTypeJson(JSON.toJSONString(warnTypeList));
        vehicleWarnUser.setLineWarnTypeJson(JSON.toJSONString(lineWarnTypeList));
        vehicleWarnUser.setCreateBy(loginUserInfo.getUserName());

        vehicleWarnUserDao.saveEntity(vehicleWarnUser);

    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateUser(VehicleWarnUserUpdateParam param) {
        VehicleWarnUser vehicleWarnUser = vehicleWarnUserDao
                .findById(param.getId()).orElseThrow(ResultEnum.DATA_NOT_FIND);
        if (!Objects.equals(vehicleWarnUser.getMobile(), param.getMobile())){
            Optional<VehicleWarnUser> optional = vehicleWarnUserDao.findByMobile(param.getMobile());
            if (optional.isPresent()){
                throw new ServiceSystemException(ResultEnum.VEHICLE_WARN_USER_EXIST);
            }
        }
        vehicleWarnUser.setName(param.getName());
        vehicleWarnUser.setMobile(param.getMobile());
        vehicleWarnUserDao.updateUser(vehicleWarnUser);
    }
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateConfig(VehicleWarnUserConfigUpdateParam param) {
        VehicleWarnUser vehicleWarnUser = vehicleWarnUserDao
                .findById(param.getId()).orElseThrow(ResultEnum.DATA_NOT_FIND);

        List<Integer> orderWarnTypeList = param.getOrderWarnTypeList().stream()
                .filter(item -> Objects.equals(item.getEnable(), 1))
                .map(VehicleWarnUserVO.WarnTypeItem::getWarnType).collect(Collectors.toList());

        List<Integer> warnTypeList = param.getWarnTypeList().stream()
                .filter(item -> Objects.equals(item.getEnable(), 1))
                .map(VehicleWarnUserVO.WarnTypeItem::getWarnType).collect(Collectors.toList());

        List<Integer> lineWarnTypeList = param.getLineWarnTypeList().stream()
                .filter(item -> Objects.equals(item.getEnable(), 1))
                .map(VehicleWarnUserVO.WarnTypeItem::getWarnType).collect(Collectors.toList());

        vehicleWarnUser.setOrderWarnTypeJson(JSON.toJSONString(orderWarnTypeList));
        vehicleWarnUser.setWarnTypeJson(JSON.toJSONString(warnTypeList));
        vehicleWarnUser.setLineWarnTypeJson(JSON.toJSONString(lineWarnTypeList));
        vehicleWarnUserDao.updateWarnType(vehicleWarnUser);

    }
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void deleteUser(VehicleWarnUserDeleteParam param) {
        VehicleWarnUser vehicleWarnUser = vehicleWarnUserDao
                .findById(param.getId()).orElseThrow(ResultEnum.DATA_NOT_FIND);
        vehicleWarnUser.setDeleteStatus(VehicleWarnUserEnum.DeleteStatus.YES.getCode());
        vehicleWarnUserDao.deleteUser(vehicleWarnUser);
    }

    @Override
    public void updateNoticeStatus(VehicleWarnUserStatusUpdateParam param) {
        VehicleWarnUser vehicleWarnUser = vehicleWarnUserDao
                .findById(param.getId()).orElseThrow(ResultEnum.DATA_NOT_FIND);
        vehicleWarnUser.setNoticeStatus(param.getNoticeStatus());
        vehicleWarnUserDao.updateNoticeStatus(vehicleWarnUser);
    }

    @Override
    public VehicleWarnUserVO getUser(Integer id) {

        return vehicleWarnUserStruct.convert(vehicleWarnUserDao.findById(id).orNull());
    }

    @Override
    public IPage<VehicleWarnUserVO> pageUser(PageVehicleWarnUserParam param) {

        return vehicleWarnUserStruct.convertPage(vehicleWarnUserDao.pageByParam(param));
    }
}
