package com.clx.performance.service.impl.settle;

import com.clx.performance.dao.settle.SettlementOwnerDetailDao;
import com.clx.performance.model.settle.SettlementOwner;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.service.broker.OrderChildBrokerMqService;
import com.clx.performance.service.settle.SettlementMqService;
import com.clx.performance.service.settle.SettlementPostService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Slf4j
@Service
public class SettlementPostServiceImpl implements SettlementPostService {

    @Autowired
    private SettlementOwnerDetailDao settlementOwnerDetailDao;

    @Autowired
    private SettlementMqService settlementMqService;

    @Autowired
    private OrderChildBrokerMqService orderChildBrokerMqService;


    @Override
    public void updateInvoiceCompany(List<SettlementOwnerDetail> list){
        for (SettlementOwnerDetail item : list) {

            // 发送mq （开票公司更新）
            settlementMqService.updateInvoiceCompany(item.getId());
        }

    }

    @Override
    public void updateDriverPaySuccess(String childNo) {
        // 发送mq (更新无车承运)
        orderChildBrokerMqService.orderChildUpdate(childNo);
    }

    @Override
    public void updatePayConfirm(SettlementOwner settlementOwner) {
        settlementMqService.settlementInvoiceStatusUpdate(settlementOwner.getSettlementNo());
    }

    @Override
    public void updateInvoice(List<String> childNoList) {
        List<SettlementOwnerDetail> settlementOwnerDetailList = settlementOwnerDetailDao.getListByChildNoList(childNoList);

        Set<String> set = settlementOwnerDetailList.stream().map(item -> item.getSettlementNo()).collect(Collectors.toSet());
        for (String item : set) {
            // 发送mq (更新无车承运)
            settlementMqService.settlementInvoiceStatusUpdate(item);
        }
    }

    @Override
    public void riskAdd(Integer id) {

        // 发送mq (风控新增)
        settlementMqService.riskAdd(id);
    }


    @Override
    public void driverSettle(String childNo) {
        // 发送mq (司机确认收货)
        settlementMqService.settlementDriverConfirm(childNo);
    }
}
