package com.clx.performance.service.impl.loan;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.loan.OwnerLoanAccountApproveDao;
import com.clx.performance.dao.loan.OwnerLoanAccountDao;
import com.clx.performance.enums.OwnerAccountEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.enums.loan.OwnerLoanAccountApproveEnum;
import com.clx.performance.model.loan.OwnerLoanAccount;
import com.clx.performance.model.loan.OwnerLoanAccountApprove;
import com.clx.performance.param.pc.loan.carrier.OwnerLoanAccountApproveParam;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanAccountApproveParam;
import com.clx.performance.service.loan.OwnerLoanAccountApproveService;
import com.clx.performance.service.loan.OwnerLoanAccountService;
import com.clx.performance.struct.loan.OwnerLoanAccountApproveStruct;
import com.clx.performance.vo.pc.loan.carrier.OwnerLoanAccountApproveVO;
import com.msl.common.base.Optional;
import com.msl.common.exception.ServiceSystemException;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Service
@Slf4j
@AllArgsConstructor
public class OwnerLoanAccountApproveServiceImpl  implements OwnerLoanAccountApproveService {

    private final OwnerLoanAccountApproveDao ownerLoanAccountApproveDao;

    private final OwnerLoanAccountApproveStruct ownerLoanAccountApproveStruct;

    private final OwnerLoanAccountService ownerLoanAccountService;
    private final OwnerLoanAccountDao ownerLoanAccountDao;
    @Override
    public IPage<OwnerLoanAccountApproveVO> pageOwnerLoanAccountApprove(PageOwnerLoanAccountApproveParam param) {
        IPage<OwnerLoanAccountApprove> page = ownerLoanAccountApproveDao.pageOwnerLoanAccountApprove(param);
        List<OwnerLoanAccountApproveVO> records = ownerLoanAccountApproveStruct.convertList(page.getRecords());
        IPage<OwnerLoanAccountApproveVO> returnPage = new Page<>();
        returnPage.setPages(page.getPages());
        returnPage.setTotal(page.getTotal());
        returnPage.setRecords(records);
        return returnPage;
    }

    public List<OwnerLoanAccountApproveVO> getOwnerLoanAccountApproveList() {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        List<OwnerLoanAccountApprove> list = ownerLoanAccountApproveDao.getOwnerLoanAccountApproveList(loginUserInfo.getCompanyNo());
        return ownerLoanAccountApproveStruct.convertList(list);
    }




    @Override
    public void openOwnerLoanAccountApprove() {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        PageOwnerLoanAccountApproveParam param = new PageOwnerLoanAccountApproveParam();
        param.setOwnerUserNo(String.valueOf(loginUserInfo.getUserNo()));
        param.setStatus(OwnerLoanAccountApproveEnum.Status.APPROVE_WAIT.getCode());
        IPage<OwnerLoanAccountApprove> page = ownerLoanAccountApproveDao.pageOwnerLoanAccountApprove(param);
        if(page.getTotal() > 0){
            throw new ServiceSystemException(PerformanceResultEnum.DATA_NOT_FIND,"您已经申请过借款用户，请勿重复申请");
        }

        Optional<OwnerLoanAccount> optional = ownerLoanAccountDao.getOneByField(OwnerLoanAccount::getOwnerUserNo,
                loginUserInfo.getUserNo());
        if(optional.isPresent()){
            throw new ServiceSystemException(PerformanceResultEnum.DATA_NOT_FIND,"您已经申请过借款用户，请勿重复申请");
        }

        OwnerLoanAccountApprove entity = new OwnerLoanAccountApprove();
        entity.setAccountType(OwnerAccountEnum.AccountTypeStatus.LOAN_ACCOUNT.getCode());
        entity.setOwnerUserNo(loginUserInfo.getUserNo());
        entity.setOwnerUserName(loginUserInfo.getUserName());
        entity.setMobile(loginUserInfo.getUserMobile());
        entity.setStatus(OwnerLoanAccountApproveEnum.Status.APPROVE_WAIT.getCode());
        entity.setCreateBy(loginUserInfo.getUserName());
        ownerLoanAccountApproveDao.saveEntity(entity);

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void ownerLoanAccountApprove(OwnerLoanAccountApproveParam param) {
        Boolean status = param.getStatus();
        OwnerLoanAccountApprove entity = ownerLoanAccountApproveDao.getEntityByKey(param.getId()).orElseThrow(
                PerformanceResultEnum.DATA_NOT_FIND);
        OwnerLoanAccountApprove update = new OwnerLoanAccountApprove();
        update.setId(param.getId());
        update.setApproveBy(TokenUtil.getLoginUserInfo().getUserName());
        update.setApproveTime(LocalDateTime.now());
        if (status) {
            //审批通过
            update.setStatus(OwnerLoanAccountApproveEnum.Status.APPROVE_PASS.getCode());
            ownerLoanAccountApproveDao.updateEntityByKey(update);
            ownerLoanAccountService.openOwnerLoanAccount(entity.getOwnerUserNo(), entity.getOwnerUserName(), entity.getMobile());
        } else {
            //审批拒绝
            update.setStatus(OwnerLoanAccountApproveEnum.Status.APPROVE_REFUSE.getCode());
            update.setRejectReason(param.getRejectReason());
            ownerLoanAccountApproveDao.updateEntityByKey(update);
        }
    }


}
