package com.clx.performance.service.impl;

import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.vo.MonthInComeAndOrderedVO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * 车队运营系统相关逻辑接口
 */

@Slf4j
@Service
@AllArgsConstructor
public class ExternalInterfaceService implements com.clx.performance.service.ExternalInterfaceService {

    private final OrderChildDao orderChildDao;


    //查询车辆近一个月的收入和订单书库来那个
    public MonthInComeAndOrderedVO getTruckMonthIncomeAndOrderedNum(String truckNo){
        LocalDateTime endTime = LocalDateTime.now();
        LocalDateTime startTime = endTime.minusMonths(1);
        return orderChildDao.statisticsTruckMonth(startTime,endTime,truckNo);
    }
}
