package com.clx.performance.model.settle;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2023-12-19
 * Time 11:34
 */
@Data
@Accessors(chain = true)
@TableName("network_driver_account")
@Builder
public class NetworkDriverAccount implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("driver_user_no")
    @Schema(description="司机编码")
    private Long driverUserNo;

    @TableField("driver_user_name")
    @Schema(description="司机名称")
    private String driverUserName;

    @TableField("mobile")
    @Schema(description="联系电话")
    private String mobile;

    @TableField("account_balance")
    @Schema(description="账户余额")
    private BigDecimal accountBalance;

    @TableField("usable_balance")
    @Schema(description="可用余额")
    private BigDecimal usableBalance;

    @TableField("frozen_balance")
    @Schema(description="冻结余额")
    private BigDecimal frozenBalance;

    @TableField("wallet_code")
    @Schema(description="钱包code")
    private String walletCode;

    @TableField("create_by")
    @Schema(description="创建人")
    private String createBy;

    @TableField("create_time")
    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
