package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author jiangwj
 * Date 2024-08-07
 * Time 16:29
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("driver_notice_config")
public class DriverNoticeConfig implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("name")
    @Schema(description="配置名称")
    private String name;

    @TableField("notice_trigger_distance")
    @Schema(description="通知触发距离")
    private BigDecimal noticeTriggerDistance;

    @TableField("status")
    @Schema(description="启用状态：0禁用1启用")
    private Integer status;

    @TableField("created_time")
    @Schema(description="创建时间")
    private LocalDateTime createdTime;

    @TableField("modified_time")
    @Schema(description="更新时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
        return this.id;
    }
}
