package com.clx.performance.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.clx.performance.dto.OrderGoodsBindTruckNumDTO;
import com.clx.performance.model.OrderGoodsTruckBind;
import com.clx.performance.sqlProvider.OrderGoodsTruckBindSqlProvider;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
* @Author: huyufan
* @Description: 货单定向绑定车辆
* @Date: 2023/09/18 11:34:50
* @Version: 1.0
*/

@Mapper
public interface OrderGoodsTruckBindMapper extends BaseMapper<OrderGoodsTruckBind> {

    @SelectProvider(type = OrderGoodsTruckBindSqlProvider.class, method = "saveBatchEntity")
    void saveBatchEntity(String orderNo, String orderGoodsNo, List<String> trackList, String now);

    @Select("select truck_no from order_goods_truck_bind where order_goods_no=#{orderGoodsNo}")
    List<Integer> getTrucksByOrderGoodsNo(@Param("orderGoodsNo") String orderGoodsNo);

    @SelectProvider(type = OrderGoodsTruckBindSqlProvider.class, method = "selectListByTruckNo")
    List<String> selectListByTruckNo(List<String> truckList);


    @SelectProvider(type = OrderGoodsTruckBindSqlProvider.class, method = "findUnreleasedTruck")
    List<String> findUnreleasedTruck();



    @SelectProvider(type = OrderGoodsTruckBindSqlProvider.class, method = "queryOrderGoodsTruckNum")
    List<OrderGoodsBindTruckNumDTO> queryOrderGoodsTruckNum(List<String> fleetNoList);


    @SelectProvider(type = OrderGoodsTruckBindSqlProvider.class, method = "batchCancelTruckList")
    void batchCancelTruckList(List<OrderGoodsTruckBind> updateList);
}