package com.clx.performance.listener.settle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeySettlementConstants;
import com.clx.performance.service.settle.SettlementMqHandlerService;
import com.clx.performance.vo.mq.SettlementSettleMqParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: 艾庆国
 * @Description: 货主结算 mq
 * @Date: 2023-10-20 11:45:08
 * @Version: 1.0
 */
@Slf4j
@Component
public class SettlementSettleListener {

    @Autowired
    private SettlementMqHandlerService settlementMqHandlerService;

    @RabbitListener(queues = RabbitKeySettlementConstants.SETTLEMENT_SETTLE_QUEUE)
    public void process(Message message) {
        try{
            log.info("结算-货主结算, message:{}", new String(message.getBody()));
            process(JSON.parseObject(new String(message.getBody()), new TypeReference<MqWrapper<SettlementSettleMqParam>>(){}).getData());
        }catch (Exception e){
            log.info("结算-货主结算 失败",e);
        }
    }

    private void process(SettlementSettleMqParam mq){

        settlementMqHandlerService.settle(mq);

    }
}
