package com.clx.performance.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.model.OrderGoodsAdjustmentPrice;
import com.clx.performance.service.OrderGoodsAdjustmentPriceService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

/**
 * 处理货单取消吨数回填
 */
@Slf4j
@Component
@AllArgsConstructor
public class SaveOrderGoodsAdjustmentPriceListener {

    private final OrderGoodsAdjustmentPriceService orderGoodsAdjustmentPriceService;


    @RabbitListener(queues = RabbitKeyConstants.SAVE_ORDER_GOODS_ADJUSTMENT_PRICE_QUEUE)
    public void onMessage(Message message) {
        try{
            log.info("监听到保存货单挂单运费调整记录,消息内容{}", new String(message.getBody()));
            OrderGoodsAdjustmentPrice data = JSON.parseObject(new String(message.getBody()),
                    new TypeReference<MqWrapper<OrderGoodsAdjustmentPrice>>() {
                    }).getData();
            orderGoodsAdjustmentPriceService.saveOrderGoodsAdjustmentPrice(data);
        }catch (Exception e){
            log.info("监听到保存货单挂单运费调整记录，异常原因：{}", ExceptionUtils.getStackTrace(e));
        }
    }
}
