package com.clx.performance.job.trace;

import com.clx.performance.dao.vehiclewarn.VehicleWarnChildDao;
import com.clx.performance.model.vehiclewarn.VehicleWarnChild;
import com.clx.performance.service.trace.TruckTraceMqService;
import com.clx.performance.utils.LocalDateTimeUtils;
import com.msl.common.job.JobLog;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Component
public class VehicleTraceJob {

    @Autowired
    private VehicleWarnChildDao vehicleWarnChildDao;
    @Autowired
    private TruckTraceMqService truckTraceMqService;


    /**
     * 车辆轨迹同步
     */
    @XxlJob("truckTraceSync")
    public void truckTraceSync() {
        try {

            List<VehicleWarnChild> list = vehicleWarnChildDao.ListTruckNoOfTrace();
            log.info("车辆轨迹同步, size:{}", list.size());

            for (VehicleWarnChild item : list) {

                LocalDateTime now = LocalDateTime.now();
                LocalDateTime beginTime = now.minusSeconds(600);

                // 发送mq (同步车辆轨迹)
                truckTraceMqService.truckTracSync(item.getTruckNo(), item.getTruckNo(), LocalDateTimeUtils.formatTime(beginTime), LocalDateTimeUtils.formatTime(now));
            }

        } catch (Exception e) {
            log.warn("车辆轨迹同步失败，异常原因:{}", ExceptionUtils.getStackTrace(e));
            JobLog.error("车辆轨迹同步失败，异常原因=====================", e);
        }
    }

}
