package com.clx.performance.job;

import com.clx.performance.service.OrderChildService;
import com.msl.common.job.JobLog;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 运单监控实时位置耗时信息job
 * @author jiangwujie
 */
@Slf4j
@Component
public class OrderChildMessageNoticeJob {

    @Autowired
    OrderChildService orderChildService;



    /**
     * 运单监控实时位置耗时信息
     */
    @XxlJob("orderChildMessageNotice")
    public void orderChildMessageNotice() {
        try {
            log.info("开始实时计算进行中的运单的实时位置计算任务================================================");
            orderChildService.orderChildMessageNotice();
            log.info("结束实时计算进行中的运单的实时位置计算任务================================================");

        } catch (Exception e) {
            log.warn("定时任务计算进行中的运单的实时位置失败，异常原因:{}", ExceptionUtils.getStackTrace(e));
            JobLog.error("定时任务计算进行中的运单的实时位置失败，异常原因=====================", e);
        }
    }
}
