package com.clx.performance.feign;


import com.clx.performance.interceptor.FeignInterceptor;
import com.msl.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;


@FeignClient(name = "user-service", configuration = {FeignInterceptor.class}, path= "/user-service/feign/carrier/driver/user")
public interface FeignUserService {

	/**
	 * 调用支付FeignAuth
	 * @return
	 */
	@GetMapping(value = "/getPaymentServiceAuth")
	Result<String> getPaymentServiceAuth();
}
