package com.clx.performance.dao.impl.vehiclewarn;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.vehiclewarn.VehicleWarnConfigDao;
import com.clx.performance.enums.vehiclewarn.VehicleWarnConfigEnum;
import com.clx.performance.mapper.vehiclewarn.VehicleWarnConfigMapper;
import com.clx.performance.model.vehiclewarn.VehicleWarnConfig;
import com.clx.performance.param.pc.vehiclewarn.PageVehicleWarnConfigParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class VehicleWarnConfigDaoImpl extends BaseDaoImpl<VehicleWarnConfigMapper, VehicleWarnConfig, Integer> implements VehicleWarnConfigDao {

    @Override
    public boolean updateConfig(VehicleWarnConfig item) {
        return update(lUdWrapper()
                .eq(VehicleWarnConfig::getId, item.getId())
                .set(VehicleWarnConfig::getWarnName, item.getWarnName())
                .set(VehicleWarnConfig::getWarnType, item.getWarnType())
                .set(VehicleWarnConfig::getWarnLevel, item.getWarnLevel())

                .set(VehicleWarnConfig::getInterval, item.getInterval())
                .set(VehicleWarnConfig::getTimeoutRatio, item.getTimeoutRatio())
                .set(VehicleWarnConfig::getLongitude, item.getLongitude())
                .set(VehicleWarnConfig::getLatitude, item.getLatitude())
                .set(VehicleWarnConfig::getAddress, item.getAddress())
                .set(VehicleWarnConfig::getRadius, item.getRadius())
        );
    }

    @Override
    public boolean updateStatus(VehicleWarnConfig item) {
        return update(lUdWrapper()
                .eq(VehicleWarnConfig::getId, item.getId())
                .set(VehicleWarnConfig::getStatus, item.getStatus())
        );
    }

    @Override
    public boolean updateDelete(VehicleWarnConfig item) {
        return update(lUdWrapper()
                .eq(VehicleWarnConfig::getId, item.getId())
                .set(VehicleWarnConfig::getDeleteStatus, item.getDeleteStatus())
        );
    }

    @Override
    public Optional<VehicleWarnConfig> findById(Integer id) {
        return Optional.of(id)
                .map(item -> lQrWrapper()
                        .eq(VehicleWarnConfig::getId, id)
                        .eq(VehicleWarnConfig::getDeleteStatus, VehicleWarnConfigEnum.DeleteStatus.NO.getCode())
                        .last("limit 1")
                )
                .map(super::getOne);
    }

    @Override
    public Optional<VehicleWarnConfig> findByName(String name) {
        return Optional.of(name)
                .map(item -> lQrWrapper()
                        .eq(VehicleWarnConfig::getWarnName, name)
                        .eq(VehicleWarnConfig::getDeleteStatus, VehicleWarnConfigEnum.DeleteStatus.NO.getCode())
                        .last("limit 1")
                )
                .map(super::getOne);
    }

    @Override
    public List<VehicleWarnConfig> listByWarnType(Integer warnType) {
        return list(lQrWrapper()
                .eq(VehicleWarnConfig::getWarnType, warnType)
                .eq(VehicleWarnConfig::getDeleteStatus, VehicleWarnConfigEnum.DeleteStatus.NO.getCode())
                .eq(VehicleWarnConfig::getStatus, VehicleWarnConfigEnum.Status.ENABLE.getCode())
        );
    }

    @Override
    public IPage<VehicleWarnConfig> pageByParam(PageVehicleWarnConfigParam param) {
        Page<VehicleWarnConfig> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageByParam(page,param);
    }

}
