package com.clx.performance.dao.impl.vehiclewarn;

import com.clx.performance.dao.vehiclewarn.VehicleWarnChildDao;
import com.clx.performance.enums.vehiclewarn.VehicleWarnChildEnum;
import com.clx.performance.mapper.vehiclewarn.VehicleWarnChildMapper;
import com.clx.performance.model.vehiclewarn.VehicleWarnChild;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class VehicleWarnChildDaoImpl extends BaseDaoImpl<VehicleWarnChildMapper, VehicleWarnChild, Integer> implements VehicleWarnChildDao {


    @Override
    public boolean updateWarnStatus(VehicleWarnChild item) {
        return update(lUdWrapper()
                .eq(VehicleWarnChild::getId, item.getId())
                .set(VehicleWarnChild::getWarnStatus, item.getWarnStatus())
        );
    }

    @Override
    public boolean updateEstimateLoadTime(VehicleWarnChild item) {
        return update(lUdWrapper()
                .eq(VehicleWarnChild::getId, item.getId())
                .set(VehicleWarnChild::getEstimateLoadTime, item.getEstimateLoadTime())
        );
    }

    @Override
    public Optional<VehicleWarnChild> findByChildNo(String childNo) {
        return Optional.of(childNo)
                .map(item -> lQrWrapper().eq(VehicleWarnChild::getChildNo, item))
                .map(super::getOne);
    }

    @Override
    public List<VehicleWarnChild> ListTruckNoOfTrace() {
        return list(lQrWrapper().select(VehicleWarnChild::getChildNo, VehicleWarnChild::getTruckNo)
                .eq(VehicleWarnChild::getWarnStatus, VehicleWarnChildEnum.WarnStatus.ENABLE.getCode()));
    }

    @Override
    public List<VehicleWarnChild> ListTruckNoOfWarn() {
        return list(lQrWrapper().select(VehicleWarnChild::getChildNo, VehicleWarnChild::getTruckNo)
                .eq(VehicleWarnChild::getWarnStatus, VehicleWarnChildEnum.WarnStatus.ENABLE.getCode())
                .orderByDesc(VehicleWarnChild::getId)
                .last("limit 10000")
        );

    }
}
