package com.clx.performance.dao.impl.settle;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.settle.SettlementOrderChildRiskDao;
import com.clx.performance.mapper.settle.SettlementOrderChildRiskMapper;
import com.clx.performance.model.settle.SettlementOrderChildRisk;
import com.clx.performance.param.pc.carrier.PageSettlementOrderChildRiskParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Objects;

@Repository
public class SettlementOrderChildRiskDaoImpl
        extends BaseDaoImpl<SettlementOrderChildRiskMapper, SettlementOrderChildRisk, Integer>
        implements SettlementOrderChildRiskDao {

    @Override
    public boolean updateProcess(SettlementOrderChildRisk item) {
        return update(lUdWrapper()
                .eq(SettlementOrderChildRisk::getId, item.getId())
                .set(SettlementOrderChildRisk::getInvoiceType, item.getInvoiceType())
                .set(SettlementOrderChildRisk::getStatus, item.getStatus())
                .set(SettlementOrderChildRisk::getProcessMethod, item.getProcessMethod())
                .set(SettlementOrderChildRisk::getProcessBy, item.getProcessBy())
                .set(SettlementOrderChildRisk::getProcessTime, item.getProcessTime())
        );
    }

    @Override
    public Optional<SettlementOrderChildRisk> getById(Integer id) {
        return Optional.of(id)
                .map(item -> lQrWrapper()
                        .eq(SettlementOrderChildRisk::getId, item)
                )
                .map(super::getOne);
    }

    @Override
    public Optional<SettlementOrderChildRisk> findLastByChildNo(String childNo) {
        return Optional.of(childNo)
                .map(item -> lQrWrapper()
                        .eq(SettlementOrderChildRisk::getChildNo, childNo)
                        .orderByDesc(SettlementOrderChildRisk::getId)
                        .last("limit 1")
                )
                .map(super::getOne);
    }

    @Override
    public IPage<SettlementOrderChildRisk> pageSettlementOrderChildRisk(PageSettlementOrderChildRiskParam param) {
        LambdaQueryWrapper<SettlementOrderChildRisk> query = new LambdaQueryWrapper<>();
        if(StringUtils.isNotBlank(param.getChildNo())){
            query.eq(SettlementOrderChildRisk :: getChildNo,param.getChildNo());
        }
        if(StringUtils.isNotBlank(param.getTruckNo())){
            query.eq(SettlementOrderChildRisk :: getTruckNo,param.getTruckNo());
        }
        if(Objects.nonNull(param.getStatus())){
            query.eq(SettlementOrderChildRisk :: getStatus,param.getStatus());
        }
        if(StringUtils.isNotBlank(param.getStartTime()) && StringUtils.isNotBlank(param.getEndTime())){
            query.between(SettlementOrderChildRisk :: getCreateTime,param.getStartTime(),param.getEndTime());
        }else {
            query.between(SettlementOrderChildRisk :: getCreateTime, LocalDateTimeUtil.now().minusMonths(3),LocalDateTimeUtil.now());
        }
        query.orderByAsc(SettlementOrderChildRisk :: getCreateTime);
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }
}