package com.clx.performance.dao.impl.export;

import com.clx.performance.dao.export.ExportTemplateDao;
import com.clx.performance.mapper.export.ExportTemplateMapper;
import com.clx.performance.model.export.ExportTemplate;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import com.msl.common.enums.WhetherEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Collections;
import java.util.List;

@Repository
public class ExportTemplateDaoImpl extends BaseDaoImpl<ExportTemplateMapper, ExportTemplate, Integer> implements ExportTemplateDao {

    @Override
    public List<ExportTemplate> listUserFunctionTemplate(String functionCode) {
        if (StringUtils.isBlank(functionCode)) {
            return Collections.emptyList();
        }
        return list(lQrWrapper()
                .eq(ExportTemplate::getExportFunctionCode, functionCode)
                .orderByDesc(ExportTemplate :: getId));
    }

    @Override
    public Optional<ExportTemplate> getUserFunctionTemplateByName(String functionCode, String name) {
        return Optional.ofNullable(functionCode)
                .filter(no -> StringUtils.isNoneBlank(functionCode, name))
                .map(no -> lQrWrapper()
                        .eq(ExportTemplate::getExportFunctionCode, functionCode)
                        .eq(ExportTemplate::getName, name))
                .map(super::getOne);

    }

    @Override
    public List<ExportTemplate> listUserFunctionsTemplate(List<String> functionCodes) {
        if (CollectionUtils.isEmpty(functionCodes)) {
            return Collections.emptyList();
        }
        return list(lQrWrapper()
                .in(ExportTemplate::getExportFunctionCode, functionCodes));
    }

    @Override
    public Optional<ExportTemplate> getById(Integer id) {
        return Optional.ofNullable(id).map(super::getById);
    }

    @Override
    public void saveTemplate(ExportTemplate template) {
        save(template);
    }

    @Override
    public void deleteTemplate(Integer id) {
        Optional.ofNullable(id).ifPresent(super::removeById);
    }

    @Override
    public void updateTemplateName(Integer id, String name) {
        update(lUdWrapper().set(ExportTemplate::getName, name)
                .eq(ExportTemplate::getId, id));
    }

    @Override
    public void updateTemplateNotDefault(String functionCode) {
        update(lUdWrapper().set(ExportTemplate::getDefaultFlag, WhetherEnum.get(false))
                .eq(ExportTemplate::getExportFunctionCode, functionCode));
    }

    @Override
    public void updateTemplateDefault(Integer templateId) {
        update(lUdWrapper().set(ExportTemplate::getDefaultFlag, WhetherEnum.get(true))
                .eq(ExportTemplate::getId, templateId));
    }

    @Override
    public long countUserFunctionTemplate(String functionCode) {
        return Optional.ofNullable(functionCode)
                .filter(no -> StringUtils.isNotBlank(functionCode))
                .map(no -> lQrWrapper()
                        .eq(ExportTemplate::getExportFunctionCode, functionCode))
                .map(baseMapper::selectCount)
                .orElse(0L);
    }
}
