package com.clx.performance.dao.impl;

import com.clx.performance.dao.DriverNoticeConfigDao;
import com.clx.performance.mapper.DriverNoticeConfigMapper;
import com.clx.performance.model.DriverNoticeConfig;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

/**
 * @author jiangwj
 * Date 2024-08-07
 * Time 16:29
 */
@Repository
public class DriverNoticeConfigDaoImpl extends BaseDaoImpl<DriverNoticeConfigMapper, DriverNoticeConfig, Integer> implements DriverNoticeConfigDao {
    @Override
    public DriverNoticeConfig listConfig() {
        return list().get(0);
    }

    @Override
    public boolean updateConfig(DriverNoticeConfig config) {
        return update(lUdWrapper()
                .eq(DriverNoticeConfig::getId, config.getId())
                .set(StringUtils.isNotBlank(config.getName()), DriverNoticeConfig::getName, config.getName())
                .set(config.getNoticeTriggerDistance() != null, DriverNoticeConfig::getNoticeTriggerDistance, config.getNoticeTriggerDistance())
                .set(config.getStatus() != null, DriverNoticeConfig::getStatus, config.getStatus())
        );
    }

    @Override
    public boolean updateStatus(Integer id, Integer status) {
        return update(lUdWrapper()
                .eq(DriverNoticeConfig::getId, id)
                .set(DriverNoticeConfig::getStatus, status)
        );
    }
}
