package com.clx.performance.controller.pc.vehiclewarn;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.vehiclewarn.*;
import com.clx.performance.service.vehiclewarn.VehicleWarnUserService;
import com.clx.performance.vo.pc.vehiclewarn.VehicleWarnUserVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;


@Slf4j
@RestController
@Validated
@Tag(name = "车辆预警-预警通知人员")
@RequestMapping(value="/pc/owner/vehicleWarnUser")
public class VehicleWarnUserController {

    @Autowired
    private VehicleWarnUserService vehicleWarnUserService;

    @Operation(summary = "新增人员", description = "<br>By:艾庆国")
    @PostMapping("/saveUser")
    @UnitCovert(result = false)
    public Result<Void> saveUser(@RequestBody @Validated VehicleWarnUserAddParam param) {

        vehicleWarnUserService.saveUser(param);

        return Result.ok();
    }

    @Operation(summary = "更新用户", description = "<br>By:艾庆国")
    @PostMapping("/updateUser")
    public Result<Void> updateUser(@RequestBody @Validated VehicleWarnUserUpdateParam param) {
        vehicleWarnUserService.updateUser(param);
        return Result.ok();
    }

    @Operation(summary = "更新通知配置", description = "<br>By:艾庆国")
    @PostMapping("/updateConfig")
    public Result<Void> updateConfig(@RequestBody @Validated VehicleWarnUserConfigUpdateParam param) {
        if (param.getOrderWarnTypeList() == null) {param.setOrderWarnTypeList(new ArrayList<>());}
        if (param.getWarnTypeList() == null) {param.setWarnTypeList(new ArrayList<>());}
        if (param.getLineWarnTypeList() == null) {param.setLineWarnTypeList(new ArrayList<>());}
        vehicleWarnUserService.updateConfig(param);
        return Result.ok();
    }

    @Operation(summary = "删除用户", description = "<br>By:艾庆国")
    @PostMapping("/deleteUser")
    public Result<Void> deleteUser(@RequestBody @Validated VehicleWarnUserDeleteParam param) {
        vehicleWarnUserService.deleteUser(param);
        return Result.ok();
    }
    @Operation(summary = "更新通知状态", description = "<br>By:艾庆国")
    @PostMapping("/updateNoticeStatus")
    public Result<Void> updateNoticeStatus(@RequestBody @Validated VehicleWarnUserStatusUpdateParam param) {
        vehicleWarnUserService.updateNoticeStatus(param);
        return Result.ok();
    }

    @Operation(summary = "获取人员信息",description = "<br>By:艾庆国")
    @GetMapping("/getUser")
    public Result<VehicleWarnUserVO> getUser(@NotNull(message = "id不能为空") @Validated Integer id) {
        return Result.ok(vehicleWarnUserService.getUser(id));
    }

    @Operation(summary = "分页搜索人员列表",description = "<br>By:艾庆国")
    @PostMapping("/pageUser")
    public Result<PageData<VehicleWarnUserVO>> pageUser(@RequestBody @Validated PageVehicleWarnUserParam param) {
        IPage<VehicleWarnUserVO> page = vehicleWarnUserService.pageUser(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
