package com.clx.performance.controller.pc.owner;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.owner.OwnerConfirmSettlementParam;
import com.clx.performance.param.pc.owner.OwnerPaymentSettlementParam;
import com.clx.performance.param.pc.owner.PageOwnerSettlementOwnerDetailParam;
import com.clx.performance.param.pc.owner.PageOwnerSettlementParam;
import com.clx.performance.service.settle.SettlementOwnerDetailService;
import com.clx.performance.service.settle.SettlementOwnerExportService;
import com.clx.performance.service.settle.SettlementOwnerService;
import com.clx.performance.vo.pc.carrier.settle.CarrierSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.owner.settle.OwnerPageSettlementOwnerVO;
import com.clx.performance.vo.pc.owner.settle.PageOwnerSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.owner.settle.SettlementPlatformAccountVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotNull;

@Slf4j
@RestController
@RequestMapping(value="/pc/owner/settlementOwner")
@Validated
@Tag(name = "货主端-货主结算")
@AllArgsConstructor
public class OwnerSettlementOwnerController {

    private final SettlementOwnerService settlementOwnerService;

    private final SettlementOwnerDetailService settlementOwnerDetailService;

    private final SettlementOwnerExportService settlementOwnerExportService;

    @Operation(summary = "结算单详情",description = "<br>By:李瑞新")
    @GetMapping("/getOwnerSettlementOwnerDetail")
    @UnitCovert(param = false)
    public Result<CarrierSettlementOwnerDetailVO> getOwnerSettlementOwnerDetail(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getCarrierSettlementOwnerDetail(id));
    }


    @Operation(summary = "确认结算单接口",description = "<br>By:李瑞新")
    @PostMapping("/updateConfirmSettlement")
    public Result updateConfirmSettlement(@RequestBody @Validated OwnerConfirmSettlementParam param) {
        settlementOwnerService.updateConfirmSettlement(param.getId());
        return Result.ok();
    }

    @Operation(summary = "获取结算平台收款账号",description = "<br>By:李瑞新")
    @GetMapping("/getSettlementPlatformAccount")
    public Result<SettlementPlatformAccountVO> getSettlementPlatformAccount() {
        return Result.ok(settlementOwnerService.getSettlementPlatformAccount());
    }

    @Operation(summary = "获取结算平台收款账号",description = "<br>By:李瑞新")
    @GetMapping("/getSettlementPlatformAccountById")
    public Result<SettlementPlatformAccountVO> getSettlementPlatformAccountById(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getSettlementPlatformAccountById(id));
    }

    @Operation(summary = "获取违约结算平台收款账号",description = "<br>By:姜文业")
    @GetMapping("/getBreakSettlementPlatformAccount")
    public Result<SettlementPlatformAccountVO> getBreakSettlementPlatformAccount(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getBreakSettlementPlatformAccount(id));
    }

    @Operation(summary = "付款接口",description = "<br>By:李瑞新")
    @PostMapping("/updatePaymentSettlement")
    public Result updatePaymentSettlement(@RequestBody @Validated OwnerPaymentSettlementParam param) {
        settlementOwnerService.updatePaymentSettlement(param);
        return Result.ok();
    }


    @Operation(summary = "付款确认接口",description = "<br>By:李瑞新")
    @PostMapping("/updatePaymentConfirmSettlement")
    public Result updatePaymentConfirmSettlement(@RequestBody @Validated OwnerConfirmSettlementParam param) {
        settlementOwnerService.updatePaymentConfirmSettlement(param.getId());
        return Result.ok();
    }

    @Operation(summary = "结算运单明细",description = "<br>By:李瑞新")
    @PostMapping("/pageOwnerSettlementOrderDetailList")
    @UnitCovert(param = false)
    public Result<PageData<PageOwnerSettlementOwnerDetailVO>> pageOwnerSettlementOrderDetailList(@RequestBody @Validated PageOwnerSettlementOwnerDetailParam param) {
        IPage<PageOwnerSettlementOwnerDetailVO> page = settlementOwnerDetailService.pageOwnerSettlementOrderDetailList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @Operation(summary = "导出结算运单明细")
    @PostMapping("/exportOwnerSettlementOrderDetail")
    public Result<Object> exportOwnerSettlementOrderDetail(@RequestBody @Validated PageOwnerSettlementOwnerDetailParam param, HttpServletResponse response) throws Exception {
        SXSSFWorkbook workbook = settlementOwnerDetailService.exportOwnerSettlementOrderDetail(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
        return null;
    }

    @Operation(summary = "货主端-结算单列表" ,description = "<br>By:刘海泉")
    @PostMapping("/pageSettlementOwner")
    @UnitCovert(param = false)
    public Result<PageData<OwnerPageSettlementOwnerVO>> pageSettlementOwner(@RequestBody @Validated PageOwnerSettlementParam param){
        IPage<OwnerPageSettlementOwnerVO> page = settlementOwnerService.pageSettlementOwner(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @Operation(summary = "货主端-导出结算单列表",description = "<br>By:艾庆国")
    @PostMapping("/exportSettlementOwner")
    public void exportSettlementOwner(@RequestBody @Validated PageOwnerSettlementParam param) {

        settlementOwnerExportService.exportSettlementOwner(param);
    }

}
