package com.clx.performance.controller.pc.loan.owner;

import com.clx.performance.param.pc.loan.carrier.OwnerRepaymentParam;
import com.clx.performance.param.pc.loan.owner.OwnerLoanRecordParam;
import com.clx.performance.service.loan.OwnerLoanAccountApproveService;
import com.clx.performance.service.loan.OwnerLoanAccountService;
import com.clx.performance.service.loan.OwnerLoanRecordService;
import com.clx.performance.service.loan.OwnerRepaymentService;
import com.clx.performance.vo.pc.loan.owner.OwnerAccountVO;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.validation.constraints.NotBlank;


@Slf4j
@RestController
@RequestMapping(value="/pc/owner/loanAccountApprove")
@Validated
@Tag(name = "货主端-资金管理（货主借款账户管理（申请借款））")
@AllArgsConstructor
public class OwnerLoanAccountController {

    private final OwnerLoanAccountApproveService ownerLoanAccountApproveService;

    private final OwnerLoanRecordService ownerLoanRecordService;

    private final OwnerLoanAccountService ownerLoanAccountService;

    private final OwnerRepaymentService ownerRepaymentService;

    @Operation(summary = "货主借款账户开通",description = "<br>By:胡宇帆")
    @GetMapping("/openOwnerLoanAccount")
    public Result<Object> openOwnerLoanAccount() {
        ownerLoanAccountApproveService.openOwnerLoanAccountApprove();
        return Result.ok();
    }

    @Operation(summary = "货主借款申请",description = "<br>By:胡宇帆")
    @PostMapping("/ownerLoanRecordSubmit")
    @UnitCovert(result = false)
    public Result<Object> ownerLoanRecordSubmit(@RequestBody OwnerLoanRecordParam param) {
        ownerLoanRecordService.ownerLoanRecordSubmit(param);
        return Result.ok();
    }

    @Operation(summary = "货主借款账户信息",description = "<br>By:刘海泉")
    @GetMapping("/getOwnerLoanAccount")
    @UnitCovert(param = false)
    public Result<OwnerAccountVO> getOwnerLoanAccount() {
        OwnerAccountVO ownerAccount = ownerLoanAccountService.getOwnerLoanAccount();
        return Result.ok(ownerAccount);
    }

    @Operation(summary = "货主还款",description = "<br>By:胡宇帆")
    @PostMapping("/ownerRepayment")
    public Result<OwnerAccountVO> ownerRepayment(@RequestBody OwnerRepaymentParam param) {
        ownerLoanAccountService.ownerRepayment(param);
        return Result.ok();
    }

    @Operation(summary = "取消支付(还款)",description = "<br>By:胡宇帆")
    @GetMapping("/ownerRepaymentCancelPay")
    public Result<Object> ownerRepaymentCancelPay(@RequestParam(value = "repaymentNo") @NotBlank String repaymentNo) {
        ownerRepaymentService.ownerRepaymentCancelPay(repaymentNo);
        return Result.ok();
    }

    @Operation(summary = "还款重新支付(只更改还款状态)",description = "<br>By:胡宇帆")
    @GetMapping("/ownerRepaymentRetryPay")
    public Result<Object> ownerRepaymentRetryPay(@RequestParam(value = "repaymentNo") @NotBlank String repaymentNo) {
        ownerRepaymentService.ownerRepaymentRetryPay(repaymentNo);
        return Result.ok();
    }
}
