package com.clx.performance.controller.pc.loan.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.loan.carrier.PageCarrierOwnerPaymentParam;
import com.clx.performance.service.loan.OwnerPaymentService;
import com.clx.performance.vo.pc.loan.carrier.CarrierOwnerPaymentVO;
import com.clx.performance.vo.pc.loan.carrier.OwnerPaymentVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/ownerPayment")
@Validated
@Tag(name = "承运端-借款管理")
@AllArgsConstructor
public class CarrierOwnerPaymentController {

    private final OwnerPaymentService ownerPaymentService;


    @Operation(summary = "付款列表",description = "<br>By:刘海泉")
    @PostMapping("/pageOwnerPayment")
    @UnitCovert(param = false)
    public Result<PageData<OwnerPaymentVO>> pageOwnerPayment(@RequestBody @Validated PageCarrierOwnerPaymentParam param) {
        IPage<OwnerPaymentVO> page  = ownerPaymentService.pageOwnerPayment(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @Operation(summary = "付款详情",description = "<br>By:刘海泉")
    @GetMapping("/getOwnerPaymentDetail")
    @UnitCovert(param = false)
    public Result<CarrierOwnerPaymentVO> getOwnerPaymentDetail(@RequestParam("id") @NotNull(message = "id不能为空") Integer id) {
        CarrierOwnerPaymentVO vo = ownerPaymentService.getOwnerPaymentDetail(id);
        return Result.ok(vo);
    }

    @Operation(summary = "付款",description = "<br>By:胡宇帆")
    @GetMapping("/pay")
    @UnitCovert(param = false)
    public Result<Object> pay(@RequestParam("id") @NotNull(message = "id不能为空") Integer id) {
        ownerPaymentService.pay(id);
        return Result.ok();
    }

    @Operation(summary = "付款重新支付(只更改借款状态)",description = "<br>By:胡宇帆")
    @GetMapping("/ownerPaymentRetryPay")
    public Result<Object> ownerPaymentRetryPay(@RequestParam(value = "id") @NotBlank Integer id) {
        ownerPaymentService.ownerPaymentRetryPay(id);
        return Result.ok();
    }


}
