package com.clx.performance.controller.pc.loan.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.loan.carrier.*;
import com.clx.performance.service.loan.BorrowerConfigService;
import com.clx.performance.vo.pc.loan.carrier.BorrowerConfigVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/borrowerConfig")
@Validated
@Tag(name = "承运端-借出方借款配置")
@AllArgsConstructor
public class CarrierBorrowerConfigController {

    private final BorrowerConfigService borrowerConfigService;


    @Operation(summary = "新增借出方配置", description = "<br>By:艾庆国")
    @PostMapping("/saveBorrowerConfig")
    @UnitCovert
    public Result<Void> saveBorrowerConfig(@RequestBody @Validated BorrowerConfigAddParam param) {
        borrowerConfigService.saveBorrowerConfig(param);

        return Result.ok();
    }

    @Operation(summary = "更新借出方配置", description = "<br>By:艾庆国")
    @PostMapping("/updateBorrowerConfig")
    public Result<Void> updateBorrowerConfig(@RequestBody @Validated BorrowerConfigUpdateParam param) {
        borrowerConfigService.updateBorrowerConfig(param);

        return Result.ok();
    }

    @Operation(summary = "更新借出方配置状态", description = "<br>By:艾庆国")
    @PostMapping("/updateStatus")
    public Result<Void> updateStatus(@RequestBody @Validated BorrowerConfigStatusUpdateParam param) {
        borrowerConfigService.updateStatus(param);

        return Result.ok();
    }

    @Operation(summary = "更新删除借出方配置", description = "<br>By:艾庆国")
    @PostMapping("/updateDelete")
    public Result<Void> updateDelete(@RequestBody @Validated BorrowerConfigDeleteUpdateParam param) {
        borrowerConfigService.updateDelete(param);

        return Result.ok();
    }

    @Operation(summary = "分页搜索借出方配置列表",description = "<br>By:艾庆国")
    @PostMapping("/pageBorrower")
    public Result<PageData<BorrowerConfigVO>> pageBorrowerConfig(@RequestBody @Validated PageBorrowerConfigParam param) {
        IPage<BorrowerConfigVO> page = borrowerConfigService.pageBorrowerConfig(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @Operation(summary = "查询所有借出方配置列表",description = "<br>By:艾庆国")
    @PostMapping("/ListBorrowerConfig")
    public Result<List<BorrowerConfigVO>> ListBorrowerConfig() {
        return Result.ok(borrowerConfigService.ListBorrowerConfig());
    }

}
