package com.clx.performance.controller.pc.driver;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.*;
import com.clx.performance.service.settle.NetworkCaseOutRecordService;
import com.clx.performance.service.settle.NetworkDriverAccountService;
import com.clx.performance.service.settle.NetworkDriverRunningWaterRecordService;
import com.clx.performance.vo.pc.*;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping("/pc/driver")
@Validated
@AllArgsConstructor
@Tag(name = "PC-车主网络货运")
public class NetworkDriverAccountController {

    private final NetworkDriverAccountService networkDriverAccountService;

    private final NetworkDriverRunningWaterRecordService networkDriverRunningWaterRecordService;

    private final NetworkCaseOutRecordService networkCaseOutRecordService;



    @Operation(summary = "网络货运账户列表", description = "<br>By:胡宇帆")
    @PostMapping("/networkAccountList")
    @UnitCovert(param = false)
    public Result<PageData<NetworkDriverAccountVO>> networkAccountList(@RequestBody PageNetworkAccountListParam param) {
        IPage<NetworkDriverAccountVO> page = networkDriverAccountService.networkAccountList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }


    @Operation(summary = "网络货运账户详情", description = "<br>By:胡宇帆")
    @PostMapping("/networkAccountInfoList")
    @UnitCovert(param = false)
    public Result<PageData<NetworkDriverRunningWaterRecordVO>> networkAccountInfoList(@RequestBody PageNetworkAccountInfoListParam param) {
        IPage<NetworkDriverRunningWaterRecordVO> page = networkDriverRunningWaterRecordService.networkDriverRunningWaterRecordList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @Operation(summary = "车主提现", description = "<br>By:胡宇帆")
    @PostMapping("/networkCaseOutRecord")
    @UnitCovert(param = false)
    public Result<PageData<NetworkCaseOutRecordVO>> networkCaseOutRecord(@RequestBody PageNetworkCaseOutRecordListParam param) {
        IPage<NetworkCaseOutRecordVO> page = networkCaseOutRecordService.networkCaseOutRecord(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }
}
