package com.clx.performance.controller.pc.collect;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.collect.CollectTrafficCongestionAuditParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTraficCongestionParam;
import com.clx.performance.service.collect.CollectTrafficCongestionService;
import com.clx.performance.vo.pc.collect.CollectTrafficCongestionVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/driver/collect/traffic")
@Validated
@Tag(name = "承运PC-交通上报")
@AllArgsConstructor
public class CarrierDriverCollectTrafficCongestionController {

    private final CollectTrafficCongestionService collectTrafficCongestionService;

    @Operation(summary = "交通上报审核", description = "<br>By:艾庆国")
    @PostMapping("/updateTrafficCongestionAudit")
    public Result<Void> updateTrafficCongestionAudit(@RequestBody @Validated CollectTrafficCongestionAuditParam param) {
        collectTrafficCongestionService.updateTrafficCongestionAudit(param);

        return Result.ok();
    }

    @Operation(summary = "分页查询交通上报列表",description = "<br>By:艾庆国")
    @PostMapping("/pageTrafficReport")
    public Result<PageData<CollectTrafficCongestionVO>> pageTrafficReport(@RequestBody @Validated CarrierPageCollectTraficCongestionParam param) {
        IPage<CollectTrafficCongestionVO> page = collectTrafficCongestionService.carrierPageTrafficReport(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
