package com.clx.performance.controller.pc.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.carrier.CarrierSettlementOwnerConfirmAccountParam;
import com.clx.performance.param.pc.carrier.CarrierSettlementOwnerConfirmSettlementParam;
import com.clx.performance.param.pc.owner.*;
import com.clx.performance.service.settle.SettlementOwnerService;
import com.clx.performance.vo.pc.carrier.settle.*;
import com.clx.performance.vo.pc.owner.settle.SettlementPlatformAccountVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotNull;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/settlementOwner")
@Validated
@Tag(name = "承运端-货主结算")
@AllArgsConstructor
public class CarrierSettlementOwnerController {

    private final SettlementOwnerService settlementOwnerService;


    @Operation(summary = "结算单详情",description = "<br>By:李瑞新")
    @GetMapping("/getCarrierSettlementOwnerDetail")
    @UnitCovert(param = false)
    public Result<CarrierSettlementOwnerDetailVO> getCarrierSettlementOwnerDetail(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getCarrierSettlementOwnerDetail(id));
    }

    @Operation(summary = "承运端-结算单列表（货主）",description = "<br>By:刘海泉")
    @PostMapping("/pageCarrierSettlementOwner")
    @UnitCovert(param = false)
    public Result<PageData<CarrierPageSettlementOwnerVO>> pageCarrierSettlementOwner(@RequestBody @Validated PageCarrierSettlementOwnerParam param) {
        IPage<CarrierPageSettlementOwnerVO> page = settlementOwnerService.pageCarrierSettlementOwner(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @Operation(summary = "货主结算单下载",description = "<br>By:姜文业")
    @PostMapping("/exportCarrierSettlementOwnerPageList")
    public void exportCarrierSettlementOwnerPageList(@RequestBody @Validated PageCarrierSettlementOwnerParam param, HttpServletResponse response) throws Exception {
        SXSSFWorkbook workbook = settlementOwnerService.exportCarrierSettlementOwnerPageList(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
    }

    @Operation(summary = "货主结算单快递页面开票信息",description = "<br>By:姜文业")
    @GetMapping("/getCarrierSettlementOwnerInvoiceCompany")
    @UnitCovert(param = false)
    public Result<CarrierSettlementOwnerCompanyVO> getCarrierSettlementOwnerInvoiceCompany(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getCarrierSettlementOwnerInvoiceCompany(id));
    }

    @Operation(summary = "货主结算单快递页面联系人信息",description = "<br>By:姜文业")
    @GetMapping("/getCarrierSettlementOwnerCompanyContact")
    @UnitCovert(param = false)
    public Result<CarrierSettlementOwnerCompanyContactVO> getCarrierSettlementOwnerCompanyContact(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getCarrierSettlementOwnerCompanyContact(id));
    }

    @Operation(summary = "货主结算单付款页面收款人信息",description = "<br>By:姜文业")
    @GetMapping("/getCarrierSettlementOwnerPayee")
    @UnitCovert(param = false)
    public Result<CarrierSettlementOwnerPayeeVO> getCarrierSettlementOwnerPayee(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getCarrierSettlementOwnerPayee(id));
    }

    @Operation(summary = "货主结算单快递页面快递信息",description = "<br>By:姜文业")
    @GetMapping("/getCarrierSettlementOwnerExpress")
    @UnitCovert(param = false)
    public Result<CarrierSettlementOwnerExpressVO> getCarrierSettlementOwnerExpress(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getCarrierSettlementOwnerExpress(id));
    }

    @Operation(summary = "货主结算单上传结算凭证",description = "<br>By:姜文业")
    @PostMapping("/uploadInvoiceImg")
    public Result uploadInvoiceImg(@RequestBody @Validated UploadInvoiceImgParam param) {
        settlementOwnerService.uploadInvoiceImg(param);
        return Result.ok();
    }

    @Operation(summary = "货主结算单填写快递信息",description = "<br>By:姜文业")
    @PostMapping("/saveExpress")
    public Result saveExpress(@RequestBody @Validated SaveExpressParam param) {
        settlementOwnerService.saveExpress(param);
        return Result.ok();
    }

    @Operation(summary = "货主结算单付款提交",description = "<br>By:姜文业")
    @PostMapping("/savePayee")
    public Result savePayee(@RequestBody @Validated SavePayeeParam param) {
        settlementOwnerService.savePayee(param);
        return Result.ok();
    }

    @Operation(summary = "编辑结算单状态",description = "<br>By:姜文业")
    @PostMapping("/updateStatusByOrderNo")
    public Result updateStatusByOrderNo(@RequestBody @Validated UpdateStatusParam param) {
        settlementOwnerService.updateStatusByOrderNo(param.getOrderNo(), param.getSettlementPeriodType(), param.getFromStatus(), param.getToStatus());
        return Result.ok();
    }

    @Operation(summary = "货主结算单付款确认",description = "<br>By:姜文业")
    @GetMapping("/payeeConfirm")
    @UnitCovert(param = false)
    public Result payeeConfirm(@NotNull(message = "结算单号不能为空") String settlementNo) {
        settlementOwnerService.payeeConfirm(settlementNo);
        return Result.ok();
    }

    @Operation(summary = "获取结算平台收款账号",description = "<br>By:李瑞新")
    @GetMapping("/getSettlementPlatformAccount")
    public Result<SettlementPlatformAccountVO> getSettlementPlatformAccount(@NotNull(message = "结算单号不能为空") String settlementNo) {
        return Result.ok(settlementOwnerService.getCarrierSettlementPlatformAccount(settlementNo));
    }

    @Operation(summary = "合并结算单",description = "<br>By:刘海泉")
    @PostMapping("/mergeOwnerSettlement")
    public Result<Object> mergeOwnerSettlement(@RequestBody @Validated MergeOwnerSettlementParam param) {
        settlementOwnerService.mergeOwnerSettlement(param);
        return Result.ok();
    }

    @Operation(summary = "确认对账",description = "<br>By:艾庆国")
    @PostMapping("/updateConfirmAccount")
    public Result updateConfirmAccount(@RequestBody @Validated CarrierSettlementOwnerConfirmAccountParam param) {
        settlementOwnerService.updateConfirmAccount(param.getId());
        return Result.ok();
    }

    @Operation(summary = "确认结算单",description = "<br>By:艾庆国")
    @PostMapping("/updateConfirmSettlement")
    public Result updateConfirmSettlement(@RequestBody @Validated CarrierSettlementOwnerConfirmSettlementParam param) {
        settlementOwnerService.updateCarrierConfirmSettlement(param.getId());
        return Result.ok();
    }



}
