package com.clx.performance.controller.pc.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.carrier.PageSettlementOrderChildRiskParam;
import com.clx.performance.param.pc.driver.BatchUpdatePayDriverSettlementParam;
import com.clx.performance.param.pc.driver.PageCarrierSettlementDriverParam;
import com.clx.performance.service.settle.SettlementDriverService;
import com.clx.performance.vo.pc.carrier.settle.CarrierPageSettlementDriverVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import jakarta.servlet.http.HttpServletResponse;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/settlementDriver")
@Validated
@Tag(name = "承运端-结算管理-车主结算单")
@AllArgsConstructor
public class CarrierSettlementDriverController {

    private final SettlementDriverService settlementDriverService;


    @Operation(summary = "结算单列表（车主）",description = "<br>By:刘海泉")
    @PostMapping("/pageCarrierSettlementDriver")
    @UnitCovert(param = false)
    public Result<PageData<CarrierPageSettlementDriverVO>> pageCarrierSettlementDriver(@RequestBody @Validated PageCarrierSettlementDriverParam param) {
        IPage<CarrierPageSettlementDriverVO> page  = settlementDriverService.pageCarrierSettlementDriver(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @Operation(summary = "批量结算车主结算单",description = "<br>By:刘海泉")
    @PostMapping("/updateBatchPayDriverSettlement")
    public Result<Object> updateBatchPayDriverSettlement(@RequestBody @Validated BatchUpdatePayDriverSettlementParam param) {
        settlementDriverService.updateBatchPayDriverSettlement(param);
        return Result.ok();
    }

    @Operation(summary = "导出车主结算单",description = "<br>By:杨启发")
    @PostMapping("/exportSettlementDriver")
    public void exportSettlementDriver(@RequestBody @Validated PageCarrierSettlementDriverParam param, HttpServletResponse response) throws Exception {
        try (SXSSFWorkbook workbook = settlementDriverService.exportSettlementDriver(param)) {
            response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
            workbook.write(response.getOutputStream());
        }
    }
}
