package com.clx.performance.controller.pc.breakcontract.owner;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.enums.BreakContractOwnerRecordEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.param.pc.breakcontract.owner.PageOwnerBreakContractOwnerRecordParam;
import com.clx.performance.param.pc.owner.OwnerConfirmBreakContractSettlementParam;
import com.clx.performance.service.breakcontract.BreakContractOwnerRecordService;
import com.clx.performance.vo.pc.breakcontract.owner.PageOwnerBreakContractOwnerRecordVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.exception.ServiceSystemException;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Objects;


@Slf4j
@RestController
@RequestMapping(value="/pc/owner/breakContract/ownerRecord")
@Validated
@Tag(name = "货主端-违约管理")
@AllArgsConstructor
public class OwnerBreakContractOwnerRecordController {

    private final BreakContractOwnerRecordService breakContractOwnerRecordService;


    @Operation(summary = "列表",description = "<br>By:李瑞新")
    @PostMapping("/pageOwnerRecord")
    @UnitCovert(param = false)
    public Result<PageData<PageOwnerBreakContractOwnerRecordVO>> pageOwnerRecord(@RequestBody @Validated PageOwnerBreakContractOwnerRecordParam param) {
        IPage<PageOwnerBreakContractOwnerRecordVO> page = breakContractOwnerRecordService.pageOwnerRecord(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }


    @Operation(summary = "更新确认状态",description = "<br>By:李瑞新")
    @PostMapping("/updateConfirmStatus")
    public Result updateConfirmStatus(@RequestBody @Validated OwnerConfirmBreakContractSettlementParam param) {

        if(Objects.equals(param.getConfirmStatus(), BreakContractOwnerRecordEnum.ConfirmStatus.REJECT.getCode())){
            if(StringUtils.isBlank(param.getRejectReason())){
                throw new ServiceSystemException(PerformanceResultEnum.REJECT_REASON_NULL);
            }
            if(param.getRejectReason().length() >100){
                throw new ServiceSystemException(PerformanceResultEnum.REJECT_REASON_TOO_LARGE);
            }
        }
        breakContractOwnerRecordService.updateConfirmStatus(param);
        return Result.ok();
    }

}
