package com.clx.performance.controller.pc.breakcontract.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.breakcontract.carrier.PageCarrierBreakContractSettlementDriverDetailParam;
import com.clx.performance.service.breakcontract.BreakContractSettlementDriverDetailService;
import com.clx.performance.vo.pc.breakcontract.carrier.PageCarrierBreakContractSettlementDriverDetailVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import jakarta.servlet.http.HttpServletResponse;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/breakContract")
@Validated
@Tag(name = "承运端-违约计费（车主）")
@AllArgsConstructor
public class CarrierBreakContractSettlementDriverDetailController {

    private final BreakContractSettlementDriverDetailService breakContractSettlementDriverDetailService;


    @Operation(summary = "列表",description = "<br>By:李瑞新")
    @PostMapping("/pageCarrierBreakContractSettlementDriverDetailList")
    @UnitCovert(param = false)
    public Result<PageData<PageCarrierBreakContractSettlementDriverDetailVO>> pageCarrierBreakContractSettlementDriverDetailList(@RequestBody  PageCarrierBreakContractSettlementDriverDetailParam param) {
        IPage<PageCarrierBreakContractSettlementDriverDetailVO> page = breakContractSettlementDriverDetailService.pageCarrierBreakContractSettlementDriverDetailList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @Operation(summary = "导出")
    @PostMapping("/exportCarrierBreakContractSettlementDriverDetailList")
    public Result exportCarrierBreakContractSettlementDriverDetailList(@RequestBody  PageCarrierBreakContractSettlementDriverDetailParam param, HttpServletResponse response) throws Exception {

        SXSSFWorkbook workbook = breakContractSettlementDriverDetailService.exportCarrierBreakContractSettlementDriverDetailList(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
        return null;
    }

}
