package com.clx.performance.controller.pc;

import com.clx.performance.service.SeniorLogisticsManagerService;
import com.clx.performance.vo.pc.SeniorLogisticsManagerVO;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @ClassName SeniorLogisticsManagerController
 * @Description
 * @Author kavin
 * @Date 2023/9/18 17:54
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping("/pc/seniorLogisticsManager")
@Validated
@Tag(name = "PC-高级物流经理")
public class SeniorLogisticsManagerController {

    @Autowired
    SeniorLogisticsManagerService seniorLogisticsManagerService;
    /**
     * @Author kavin
     * @Description 获取高级物流经理
     * @Param []
     * @return
     **/
    @Operation(summary = "高级物流经理下拉选",description = "<br>By:刘海泉")
    @GetMapping("/getList")
    public Result<List<SeniorLogisticsManagerVO>> getList(){
        List<SeniorLogisticsManagerVO> list  = seniorLogisticsManagerService.getList();
        return Result.ok(list);
    }

}
