package com.clx.performance.controller.pc;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.IntegralTruckAddParam;
import com.clx.performance.param.pc.PageIntegralTruckParam;
import com.clx.performance.param.pc.PageIntegralTruckRankParam;
import com.clx.performance.service.IntegralTruckService;
import com.clx.performance.vo.pc.IntegralTruckVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/integral")
@Validated
@Tag(name = "承运端-积分车辆")
@AllArgsConstructor
public class IntegralTruckController {

    private final IntegralTruckService integralTruckService;

    @Deprecated
    @Operation(summary = "新增车辆", description = "<br>By:艾庆国")
//    @PostMapping("/saveTruck")
    public Result<Void> saveTruck(@RequestBody @Validated IntegralTruckAddParam param) {
        integralTruckService.saveTruck(param);

        return Result.ok();
    }

    @Deprecated
    @Operation(summary = "获取车辆列表", description = "<br>By:艾庆国")
//    @PostMapping(value = "pageTruckList")
    public Result<PageData<IntegralTruckVO>> pageTruckList(@RequestBody @Validated PageIntegralTruckParam param) {

        IPage<IntegralTruckVO> page = integralTruckService.pageTruckList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @Operation(summary = "查询车辆所属司机信息", description = "<br>By:艾庆国")
    @Parameters({
            @Parameter(name = "truckNo", description = "车牌号", in = ParameterIn.QUERY, example = "京A123456")
    })
    @GetMapping(value = "getTruckDriverInfo")
    public Result<IntegralTruckVO> getTruckDriverInfo(@Validated @NotBlank(message = "车牌不能为空") String truckNo) {

        return Result.ok(integralTruckService.getTruckDriverInfo(truckNo));
    }

    @Operation(summary = "获取车辆数量", description = "<br>By:艾庆国")
    @Parameters({
            @Parameter(name = "truckEchelon", description = "车辆梯队", in = ParameterIn.QUERY, example = "1")
    })
    @GetMapping(value = "getTruckCount")
    public Result<Integer> getTruckCount(@Validated @NotNull(message = "车辆梯队不能为空") Integer truckEchelon) {

        return Result.ok(integralTruckService.getTruckCount(truckEchelon));
    }

    @Operation(summary = "获取车辆积分排名", description = "<br>By:艾庆国")
    @RequestMapping(value = "pageTruckRank", method = RequestMethod.POST)
    public Result<PageData<IntegralTruckVO>> pageTruckRank(@RequestBody @Validated PageIntegralTruckRankParam param) {
        IPage<IntegralTruckVO> page = integralTruckService.pageTruckRank(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());

    }

}
