package com.clx.performance.controller.feign;


import com.clx.performance.param.pc.OrderCancelFeignParam;
import com.clx.performance.param.pc.OrderCancelParam;
import com.clx.performance.service.OrderCancelService;
import com.msl.common.result.Result;
import com.msl.user.utils.TokenUtil;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping("/feign/order")
@Validated
@AllArgsConstructor
@Tag(name = "Feign-订单取消")
public class OrderCancelFeignController {


    private final OrderCancelService orderCancelService;

    @Operation(summary = "承运端发起订单取消货主端进行确认", description = "<br>By:胡宇帆")
    @PostMapping("/orderCancel")
    public Result<Object> orderCancel(@RequestBody OrderCancelFeignParam param) {
        orderCancelService.ownerConfirmCancelOrderPre(param.getOrderNo());
        return Result.ok();
    }

}
