package com.clx.performance.controller.app;

import com.clx.performance.param.app.OrderChildWeighPictureParam;
import com.clx.performance.service.OrderChildWeighPictureService;
import com.clx.performance.vo.app.PictureVo;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Slf4j
@RestController
@RequestMapping(value="/app/driver/orderChildWeighPicture")
@Validated
@Tag(name = "APP-运单电子磅单")
public class AppDriverOrderChildWeighPictureController {

    @Autowired
    private OrderChildWeighPictureService pictureService;



    @Operation(summary = "查询电子磅单", description = "<br>By:李瑞新")
    @PostMapping("/getWeighPictures")
    public Result<PictureVo> getWeighPictures(@RequestBody @Validated OrderChildWeighPictureParam param) {

        return Result.ok(pictureService.getWeighPictures(param));
    }

}
