package com.clx.performance.controller.app;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.collect.CollectTruckLocationSaveParam;
import com.clx.performance.param.app.collect.PageCollectTruckLocationParam;
import com.clx.performance.service.collect.CollectTruckLocationService;
import com.clx.performance.vo.pc.collect.CollectTruckLocationVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping(value="/app/driver/collect/location")
@Validated
@Tag(name = "APP-位置上报")
@AllArgsConstructor
public class AppDriverCollectTruckLocationController {

    private final CollectTruckLocationService collectTruckLocationService;

    @Operation(summary = "上报位置", description = "<br>By:艾庆国")
    @PostMapping("/saveLocationReport")
    public Result<Void> saveLocationReport(@RequestBody @Validated CollectTruckLocationSaveParam param) {
        collectTruckLocationService.saveLocationReport(param);

        return Result.ok();
    }

    @Operation(summary = "查询位置上报详情", description = "<br>By:艾庆国")
    @GetMapping("/getReportInfo")
    public Result<CollectTruckLocationVO> getReportInfo(Integer id) {

        return Result.ok(collectTruckLocationService.getReportInfo(id));
    }

    @Operation(summary = "分页查询位置上报列表",description = "<br>By:艾庆国")
    @PostMapping("/pageLocationReport")
    @UnitCovert(param = false)
    public Result<PageData<CollectTruckLocationVO>> pageLocationReport(@RequestBody @Validated PageCollectTruckLocationParam param) {
        IPage<CollectTruckLocationVO> page = collectTruckLocationService.pageLocationReport(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
