package com.clx.performance.config;

import com.clx.performance.constant.RabbitKeySettlementConstants;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: aiqingguo
 * @Description: 司机积分 MQ
 * @Date: 2023-10-12 16:27:30
 * @Version: 1.0
 */
@Configuration
public class RabbitSettlementConfig {

    @Bean
    public DirectExchange settlementDefaultExchange() {
        return new DirectExchange(RabbitKeySettlementConstants.DEFAULT_EXCHANGE);
    }

    @Bean
    public Queue settlementDefaultDelayQueue() {
        Map<String, Object> params = new HashMap<>(8);
        params.put("x-message-ttl", 15 * 60 * 1000);
        params.put("x-max-length", 5000000);
        params.put("x-dead-letter-exchange", RabbitKeySettlementConstants.DEFAULT_EXCHANGE);
        params.put("x-dead-letter-routing-key", RabbitKeySettlementConstants.DEFAULT_DEAD_ROUTING_KEY);
        return new Queue(RabbitKeySettlementConstants.DEFAULT_DELAY_QUEUE, true, false, false, params);
    }
    @Bean
    public Binding settlementDefaultDelayQueueBinding() {
        return BindingBuilder.bind(settlementDefaultDelayQueue()).to(settlementDefaultExchange()).with(RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY);
    }

    @Bean
    public Queue settlementDefaultDeadQueue() {
        return new Queue(RabbitKeySettlementConstants.DEFAULT_DEAD_QUEUE);
    }
    @Bean
    public Binding settlementDefaultDeadQueueBinding() {
        return BindingBuilder.bind(settlementDefaultDeadQueue()).to(settlementDefaultExchange()).with(RabbitKeySettlementConstants.DEFAULT_DEAD_ROUTING_KEY);
    }


    /**
     * 计费明细新增
     */
    @Bean
    public Queue settlementDetailAddQueue() {
        return new Queue(RabbitKeySettlementConstants.SETTLEMENT_DETAIL_ADD_QUEUE);
    }
    @Bean
    public Binding settlementDetailAddQueueBinding() {
        return BindingBuilder.bind(settlementDetailAddQueue()).to(settlementDefaultExchange()).with(RabbitKeySettlementConstants.SETTLEMENT_DETAIL_ADD_ROUTING_KEY);
    }

    /**
     * 计费明细新增
     */
    @Bean
    public Queue settlementDetailInvoiceTypeSyncQueue() {
        return new Queue(RabbitKeySettlementConstants.SETTLEMENT_DETAIL_INVOICE_TYPE_SYC_QUEUE);
    }
    @Bean
    public Binding settlementDetailInvoiceTypeSyncQueueBinding() {
        return BindingBuilder.bind(settlementDetailInvoiceTypeSyncQueue()).to(settlementDefaultExchange()).with(RabbitKeySettlementConstants.SETTLEMENT_DETAIL_INVOICE_TYPE_SYC_ROUTING_KEY);
    }

    /**
     * 开票方式同步
     */
    @Bean
    public Queue settlementInvoiceTypeSyncQueue() {
        return new Queue(RabbitKeySettlementConstants.SETTLEMENT_INVOICE_TYPE_SYNC_QUEUE);
    }
    @Bean
    public Binding settlementInvoiceTypeSyncQueueBinding() {
        return BindingBuilder.bind(settlementInvoiceTypeSyncQueue()).to(settlementDefaultExchange())
                .with(RabbitKeySettlementConstants.SETTLEMENT_INVOICE_TYPE_SYNC_ROUTING_KEY);
    }

    /**
     * 开票方式同步
     */
    @Bean
    public Queue settlementDriverPayAcceptSyncQueue() {
        return new Queue(RabbitKeySettlementConstants.SETTLEMENT_DRIVER_PAY_ACCEPT_SYNC_QUEUE);
    }
    @Bean
    public Binding settlementDriverPayAcceptSyncQueueBinding() {
        return BindingBuilder.bind(settlementDriverPayAcceptSyncQueue()).to(settlementDefaultExchange())
                .with(RabbitKeySettlementConstants.SETTLEMENT_DRIVER_PAY_ACCEPT_SYNC_ROUTING_KEY);
    }

    /**
     * 货主结算
     */
    @Bean
    public Queue settlementSettleQueue() {
        return new Queue(RabbitKeySettlementConstants.SETTLEMENT_SETTLE_QUEUE);
    }
    @Bean
    public Binding settlementSettleQueueBinding() {
        return BindingBuilder.bind(settlementSettleQueue()).to(settlementDefaultExchange())
                .with(RabbitKeySettlementConstants.SETTLEMENT_SETTLE_ROUTING_KEY);
    }

    /**
     * 车主结算
     */
    @Bean
    public Queue settlementDriverSettlementQueue() {
        return new Queue(RabbitKeySettlementConstants.SETTLEMENT_DRIVER_SETTLE_QUEUE);
    }
    @Bean
    public Binding settlementDriverSettlementQueueBinding() {
        return BindingBuilder.bind(settlementDriverSettlementQueue()).to(settlementDefaultExchange())
                .with(RabbitKeySettlementConstants.SETTLEMENT_DRIVER_SETTLE_ROUTING_KEY);
    }

    /**
     * 支付状态
     */
    @Bean
    public Queue settlementPayStatusSyncQueue() {
        return new Queue(RabbitKeySettlementConstants.SETTLEMENT_PAY_STATUS_SYNC_QUEUE);
    }
    @Bean
    public Binding settlementPayStatusSyncQueueBinding() {
        return BindingBuilder.bind(settlementPayStatusSyncQueue()).to(settlementDefaultExchange())
                .with(RabbitKeySettlementConstants.SETTLEMENT_PAY_STATUS_SYNC_ROUTING_KEY);
    }
    /**
     * 开票状态
     */
    @Bean
    public Queue settlementInvoiceSyncQueue() {
        return new Queue(RabbitKeySettlementConstants.SETTLEMENT_INVOICE_STATUS_SYNC_QUEUE);
    }
    @Bean
    public Binding settlementInvoiceSyncQueueBinding() {
        return BindingBuilder.bind(settlementInvoiceSyncQueue()).to(settlementDefaultExchange())
                .with(RabbitKeySettlementConstants.SETTLEMENT_INVOICE_STATUS_SYNC_ROUTING_KEY);
    }

    /**
     * 风控新增
     */
    @Bean
    public Queue settlementRiskAddQueue() {
        return new Queue(RabbitKeySettlementConstants.SETTLEMENT_RISK_ADD_QUEUE);
    }
    @Bean
    public Binding settlementRiskAddQueueBinding() {
        return BindingBuilder.bind(settlementRiskAddQueue()).to(settlementDefaultExchange())
                .with(RabbitKeySettlementConstants.SETTLEMENT_RISK_ADD_ROUTING_KEY);
    }
    /**
     * 风控处理
     */
    @Bean
    public Queue settlementRiskProcessQueue() {
        return new Queue(RabbitKeySettlementConstants.SETTLEMENT_RISK_PROCESS_QUEUE);
    }
    @Bean
    public Binding settlementRiskProcessQueueBinding() {
        return BindingBuilder.bind(settlementRiskProcessQueue()).to(settlementDefaultExchange())
                .with(RabbitKeySettlementConstants.SETTLEMENT_RISK_PROCESS_ROUTING_KEY);
    }

    /**
     * 开票公司新增
     */
    @Bean
    public Queue settlementInvoiceCompanyUpdateQueue() {
        return new Queue(RabbitKeySettlementConstants.SETTLEMENT_INVOICE_COMPANY_UPDATE_QUEUE);
    }
    @Bean
    public Binding settlementInvoiceCompanyUpdateQueueBinding() {
        return BindingBuilder.bind(settlementInvoiceCompanyUpdateQueue()).to(settlementDefaultExchange())
                .with(RabbitKeySettlementConstants.SETTLEMENT_INVOICE_COMPANY_UPDATE_ROUTING_KEY);
    }

    /**
     * 平台自动确认
     */
    @Bean
    public Queue settlementPlatformAutoConfirmUpdateQueue() {
        return new Queue(RabbitKeySettlementConstants.SETTLEMENT_PLATFORM_AUTO_CONFIRM_UPDATE_QUEUE);
    }
    @Bean
    public Binding settlementPlatformAutoConfirmUpdateQueueBinding() {
        return BindingBuilder.bind(settlementPlatformAutoConfirmUpdateQueue()).to(settlementDefaultExchange())
                .with(RabbitKeySettlementConstants.SETTLEMENT_PLATFORM_AUTO_CONFIRM_UPDATE_ROUTING_KEY);
    }

    /**
     * 结算单开票状态更新
     */
    @Bean
    public Queue settlementInvoiceStatusUpdateQueue() {
        return new Queue(RabbitKeySettlementConstants.SETTLEMENT_INVOICE_STATUS_UPDATE_QUEUE);
    }
    @Bean
    public Binding settlementInvoiceStatusUpdateQueueBinding() {
        return BindingBuilder.bind(settlementInvoiceStatusUpdateQueue()).to(settlementDefaultExchange())
                .with(RabbitKeySettlementConstants.SETTLEMENT_INVOICE_STATUS_UPDATE_ROUTING_KEY);
    }

    /**
     * 司机确认收货
     */
    @Bean
    public Queue settlementDriverConfirmQueue() {
        return new Queue(RabbitKeySettlementConstants.SETTLEMENT_DRIVER_CONFIRM_QUEUE);
    }
    @Bean
    public Binding settlementDriverConfirmQueueBinding() {
        return BindingBuilder.bind(settlementDriverConfirmQueue()).to(settlementDefaultExchange())
                .with(RabbitKeySettlementConstants.SETTLEMENT_DRIVER_CONFIRM_ROUTING_KEY);
    }

}
