package com.clx.performance.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.order.feign.OrderFeign;
import com.clx.order.params.PageOrderGoodsListParam;
import com.clx.order.vo.feign.FeignOrderVO;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.dao.OrderGoodsDriverTruckDao;
import com.clx.performance.dao.OrderGoodsTruckBindDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.OrderGoodsDriverTruck;
import com.clx.performance.model.OrderGoodsTruckBind;
import com.clx.performance.param.app.OrderGoodsListPageParam;
import com.clx.performance.service.OrderGoodsService;
import com.clx.performance.struct.OrderGoodsStruct;
import com.clx.performance.vo.app.OrderGoodsAPPVO;
import com.clx.performance.vo.feign.OrderGoodsFeignVO;
import com.clx.performance.vo.pc.OrderGoodsVO;
import com.clx.user.feign.UserClxFeign;
import com.msl.common.exception.ServiceSystemException;
import com.msl.common.result.Result;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
@Service
public class OrderGoodsServiceImpl implements OrderGoodsService {

    @Autowired
    private OrderGoodsDao orderGoodsDao;

    @Autowired
    private OrderGoodsStruct orderGoodsStruct;

    @Autowired
    private OrderFeign orderFeign;

    @Autowired
    private OrderGoodsTruckBindDao orderGoodsTruckBindDao;

    @Autowired
    private OrderGoodsDriverTruckDao orderGoodsDriverTruckDao;

    @Autowired
    private UserClxFeign userClxFeign;

    @Override
    public OrderGoodsVO getOrderGoodsInfoByOrderGoodsNoForPC(String orderGoodsNo) {
        OrderGoodsVO orderGoodsVO = orderGoodsDao.getOrderGoodsInfoByOrderGoodsNoForPC(orderGoodsNo).map(orderGoodsStruct::convert).get();
        String orderNo = orderGoodsVO.getOrderNo();
        FeignOrderVO orderInfoFeign = orderFeign.getOrderInfoFeign(orderNo);
        orderGoodsVO.setReveiveAddressAll(orderInfoFeign.getReveiveAddressAll());
        orderGoodsVO.setSendAddressAll(orderInfoFeign.getSendAddressAll());
        return orderGoodsVO;
    }

    @Override
    public OrderGoodsVO getOrderGoodsInfoByOrderGoodsNoForAPP(String orderGoodsNo) {
        OrderGoodsVO orderGoodsVO = orderGoodsDao.getOrderGoodsInfoByOrderGoodsNoForAPP(orderGoodsNo).map(orderGoodsStruct::convert).get();
        String orderNo = orderGoodsVO.getOrderNo();
        FeignOrderVO orderInfoFeign = orderFeign.getOrderInfoFeign(orderNo);
        orderGoodsVO.setReveiveAddressAll(orderInfoFeign.getReveiveAddressAll());
        orderGoodsVO.setSendAddressAll(orderInfoFeign.getSendAddressAll());
        orderGoodsVO.setResidueTransportWeight(BigDecimal.ZERO.compareTo(orderGoodsVO.getResidueTransportWeight()) > 0?BigDecimal.ZERO:orderGoodsVO.getResidueTransportWeight());
        return orderGoodsVO;
    }

    @Override
    public IPage<OrderGoodsVO> pageOrderGoodsList(PageOrderGoodsListParam param) {
        return orderGoodsDao.pageOrderGoodsList(param);
    }

    @Override
    public void updateOrderGoodsReduceWeightAndStatus(Integer id, BigDecimal orderChildWeight, Integer orderGoodsStatus) {
        orderGoodsDao.updateOrderGoodsReduceWeightAndStatus(id, orderChildWeight, orderGoodsStatus);
    }

    @Override
    public IPage<OrderGoodsAPPVO> indexOrderGoodsList(OrderGoodsListPageParam orderGoodsListParam) {
        if (StringUtils.equals(orderGoodsListParam.getOrderGoodsType(), "1")) {
            return orderGoodsDao.openOrderPageGoodsList(orderGoodsListParam);
        } else {
            List<OrderGoodsDriverTruck> truckList = orderGoodsDriverTruckDao.
                    selectListByDriverUserNo(orderGoodsListParam.getDriverUserNo())
                    .orElseThrow(PerformanceResultEnum.DATA_NOT_FIND, "当前用户未绑定车辆");
            List<String> truckNoList = null;
            if (truckList.isEmpty()) {
                //查询当前用户是否是货主
                Long driverUserNo = orderGoodsListParam.getDriverUserNo();
                Result<List<String>> ownTruckByUserNo = userClxFeign.getOwnTruckByUserNo(driverUserNo);
                if (ownTruckByUserNo.getCode() == 200) {
                    if (ownTruckByUserNo.getData().isEmpty()) {
                        throw new ServiceSystemException(PerformanceResultEnum.DATA_NOT_FIND, "当前用户未绑定车辆");
                    }
                    truckNoList = ownTruckByUserNo.getData();
                }
            } else {
                truckNoList = truckList.stream().map(OrderGoodsDriverTruck::getTruckNo).collect(Collectors.toList());
            }
            List<OrderGoodsTruckBind> orderGoodsDriverTrucks = orderGoodsTruckBindDao.selectListByTruckNo(truckNoList)
                    .orElseThrow(PerformanceResultEnum.DATA_NOT_FIND, "当前用户没有专属单");
            if (orderGoodsDriverTrucks.isEmpty()) {
                throw new ServiceSystemException(PerformanceResultEnum.DATA_NOT_FIND, "当前用户没有专属单");

            }
            List<String> orderGoodsNoList = orderGoodsDriverTrucks.stream().map(OrderGoodsTruckBind::getOrderGoodsNo).collect(Collectors.toList());
            return orderGoodsDao.exclusiveOrderPageGoodsList(orderGoodsListParam, orderGoodsNoList);
        }
    }

    @Override
    public List<OrderGoodsFeignVO> getOrderGoodsListByOrderNo(String orderNo) {
        List<OrderGoods> list = orderGoodsDao.getOrderGoodsListByOrderNo(orderNo);
        return orderGoodsStruct.convertList(list);
    }

    @Override
    public List<OrderGoods> getOrderGoodsList(String orderNo, LocalDateTime lastArriveSendTime) {
        return orderGoodsDao.getOrderGoodsListByOrderNoAndLastArriveSendTime(orderNo, lastArriveSendTime);
    }


}
