package com.clx.performance.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.*;
import com.clx.performance.param.pc.OrderChildCarrierCancelParam;
import com.clx.performance.param.pc.PageCarrierOrderChildParam;
import com.clx.performance.param.pc.PagePoundAuditParam;
import com.clx.performance.vo.app.*;
import com.clx.performance.vo.pc.*;

import java.util.List;


/**
 * @Author: aiqinguo
 * @Description: 运单表
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */

public interface OrderChildService {

    SaveOrderChildVO saveOrderChild(OrderChildSaveParam param);

    void updateReject(OrderChildRejectParam param);

    void updateGotoSendAddress(OrderChildGoToSendAddressParam param);
    void updateArriveSendAddress(OrderChildArriveSendAddressParam param);
    void updateGotoReceiveAddress(OrderChildGoToReceiveAddressParam param);
    void updateArriveReceiveAddress(OrderChildArriveReceiveAddressParam param);

    void updateLoad(OrderChildLoadParam param);
    void updateUnload(OrderChildUnloadParam param);
    void updateLoadAndUnloadAgain(OrderChildLoadAndUnloadAgainParam param);

    void updateDriverConfirm(OrderChildDriverConfirmParam param);
    void updateDriverCancel(OrderChildDriverCancelParam param);

    void updateCarrierCancel(OrderChildCarrierCancelParam param);

    OrderChildVO getOrderChildInfo(String childNo);

    IPage<OrderChildVO> pageOrderChild(PageOrderChildOfDriverParam param);
    IPage<OrderChildVO> pageSearchOrderChild(PageOrderChildOfDriverSearchParam param);

    OrderChildEstimatedFreightVO getEstimatedFreight(OrderChildEstimatedFreightParam param);
    OrderChildPoundInfoVO getOrderChildPoundInfo(String childNo);
    OrderChildFreightInfoVO getOrderChildFreightInfo(String childNo);

    IPage<PageOrderChildPoundAuditVO> pagePoundAuditList(PagePoundAuditParam param);

    IPage<PageCarrierOrderChildVO> pageCarrierOrderChildList(PageCarrierOrderChildParam param);

    List<OrderChildPCVO> getOrderChildInfoByOrderGoodsNo(String orderGoodsNo);

    CarrierOrderChildDetailVO getCarrierOrderChildDetail(String childNo);

    GoingOrderChildVO getGoingLatestOrderChild();

    Integer getOrderChildTotalByUserNo(Long userNo);

    OrderChildBussInfoVO getOrderChildBussInfo(String truckNo);
}
