package com.clx.performance.listener;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.dao.OrderGoodsDriverTruckDao;
import com.clx.performance.model.OrderGoodsDriverTruck;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Slf4j
public class OrderGoodsDriverTruckListener {


    @Autowired
    private OrderGoodsDriverTruckDao orderGoodsDriverTruckDao;

    @RabbitListener(queues = RabbitKeyConstants.ORDER_GOODS_SYNC_TRUCK_DRIVER_INFO_QUEUE)
    @Transactional(rollbackFor = Exception.class)
    public void onMessage(Message message) throws Exception {
        log.info("处理货单定向司机表,数据为{}", message);
        JSONArray jsonArray = JSONUtil.parseArray(new String(message.getBody()));
        if (jsonArray.isEmpty()) {
            log.info("处理货单定向司机表,数据为空,不处理");
            return;
        }
        for (Object o : jsonArray) {
            JSONObject jsonObject = (JSONObject) o;
            Object driverUserNo = jsonObject.getByPath("driverUserNo");
            Object operateType = jsonObject.getByPath("operateType");
            Object driverName = jsonObject.getByPath("driverName");
            Object truckNo = jsonObject.getByPath("truckNo");
            Object driverMobile = jsonObject.getByPath("driverMobile");

            switch (operateType.toString()) {
                case "1":
                    OrderGoodsDriverTruck driverTruck = new OrderGoodsDriverTruck();
                    driverTruck.setTruckNo(truckNo == null ? "" : truckNo.toString());
                    driverTruck.setDriverMobile(driverMobile == null ? "" : driverMobile.toString());
                    driverTruck.setDriverName(driverName == null ? "" : driverName.toString());
                    driverTruck.setDriverUserNo(driverUserNo == null ? null : Long.valueOf(driverUserNo.toString()));
                    orderGoodsDriverTruckDao.saveEntity(driverTruck);
                    log.info("处理货单定向司机表：执行插入");
                    break;
                case "2":
                    if (truckNo == null || driverUserNo == null) {
                        break;
                    }
                    orderGoodsDriverTruckDao.deleteByTruckNoAndDriverUserNo(truckNo.toString(), driverUserNo.toString());
                    log.info("处理货单定向司机表：执行删除");
                    break;
                default:
                    break;
            }
        }

    }
}
