package com.clx.performance.component;

import com.clx.performance.constant.RedisConstants;
import com.clx.performance.dao.OrderGoodsDao;
import com.msl.common.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.time.LocalDate;

@Component
public class OrderGoodsIdGenerate {

    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Autowired
    private OrderGoodsDao orderGoodsDao;


    public long getOrderGoodsId(String type, Integer size) {
        long baseStart = Long.parseLong(DateUtils.formatDate(LocalDate.now(), "yyyyMMdd").get() + "00001");
        Object o = redisTemplate.opsForHash().get(RedisConstants.ORDER_GOODS_ID, type);
        if (o == null ) {
            Long maxOrderGoodsId = null;
            String maxID = orderGoodsDao.getMaxOrderGoodsId(type);
            if (StringUtils.isNotBlank(maxID)) {
                maxOrderGoodsId = Long.valueOf(maxID.substring(0, 2));
            }

            if (maxOrderGoodsId == null) {
                maxOrderGoodsId = 0L;
            }
            if (baseStart > maxOrderGoodsId) {
                redisTemplate.opsForHash().put(RedisConstants.ORDER_GOODS_ID, type, String.valueOf(baseStart + size));
                return baseStart;
            } else {
                long orderGoodsId = maxOrderGoodsId + size;
                redisTemplate.opsForHash().put(RedisConstants.ORDER_GOODS_ID, type, String.valueOf(orderGoodsId));
                return maxOrderGoodsId + 1;
            }
        } else {
            long redisOrderGoodsId = Long.parseLong(o.toString());
            if (redisOrderGoodsId < baseStart) {
                redisOrderGoodsId = baseStart;
            }
            long orderGoodsId = redisOrderGoodsId + size;
            redisTemplate.opsForHash().put(RedisConstants.ORDER_GOODS_ID, type, String.valueOf(orderGoodsId));
            return redisOrderGoodsId;
        }
    }
}
