package com.clx.performance.enums;

import com.msl.common.enums.ResultEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;


@Getter
@AllArgsConstructor
public enum PerformanceResultEnum implements ResultEnum {



    /**
     * 系统
     */
    SIGN_NULL(1001, "签名不存在"),
    SIGN_ERROR(1002, "签名错误"),
    TIMESTAMP_ERROR(1003, "请求不在时间范围内"),
    INCREMENT_ERROR(1004, "编码生成失败"),
    HTTP_ERROR(1005, "HTTP请求失败"),
    LOCK_ERROR(1006,"加锁失败"),
    TRY_LOCK_ERROR(1007,"操作频繁,请稍后重试"),
    FEIGN_ERROR(1008, "服务调用失败"),
    /**
     * 通用
     */
    USER_NULL(1101, "用户不存在"),
    MOBILE_NULL(1102, "手机号码未注册"),
    USER_NOT_REGISTER(1103, "用户尚未注册"),
    USER_NOT_AUTH(1104, "用户暂未实名"),
    DATA_NOT_FIND(1105, "数据不存在"),
    DATA_REPEAT(1106, "数据重复"),


    ORDER_NO_FOUND(1200, "货单不存在"),
    ORDER_WEIGHT_LACK(1201, "剩余数量不足"),
    ORDER_INVALID(1202, "无效的货单"),
    ORDER_INVALID1(1203, "当前运单的货源已完成或取消，请查看其他货源"),


    ORDER_CHILD_NO_FOUND(1301, "运单不存在"),
    ORDER_CHILD_STATUS_CHANGED(1302, "运单状态已变更，请重新刷新页面"),
    ORDER_CHILD_CANCELED(1303, "运单状态已取消"),
    ORDER_CHILD_COMPLETE(1304, "运单状态已完成"),
    ORDER_CHILD_LOAD_TIMEOUT(1305, "超过最晚到达货源地时间"),
    ORDER_CHILD_CANCEL_FORBID(1306, "运单无法取消"),
    ORDER_CHILD_CANCEL_FORBID_COUNT(1307, "今日取消运单次数超过上限，暂时无法取消"),
    ORDER_CHILD_POUND_AUDIT(1308, "磅单审核中"),
    ORDER_CHILD_POUND_REJECT(1309, "磅单审核驳回，请重新提交信息"),
    ORDER_CHILD_DIRECT_ORDER_TRUCK_ERROR(1310, "请选择定向车辆"),
    ORDER_CHILD_DIRECT_ORDER_TRUCK_ERROR1(1311, "请选择非定向车辆"),
    ORDER_CHILD_DIRECT_REJECT_TRUCK_ERROR(1312, "非定向车辆无法取消"),
    ORDER_CHILD_TRUCK_MODEL_ERROR(1313, "请选择合适的车型"),

    ORDER_CHILD_LOAD_WEIGHT_ERROR(1314, "装货净重超过载重的1.5倍"),
    ORDER_CHILD_UNLOAD_WEIGHT_ERROR(1315, "卸货净重超过载重的1.5倍"),
    ORDER_CHILD_LOAD_TIME_ERROR(1316, "非装车时间段"),
    ORDER_CHILD_UNLOAD_TIME_ERROR(1317, "非卸车时间段"),
    ORDER_CHILD_ARRIVE_SEND_ADDRESS_DISTANCE_ERROR(1318, "没有到达货源地"),
    ORDER_CHILD_ARRIVE_RECEIVE_ADDRESS_DISTANCE_ERROR(1319, "没有到达目的地"),

    ;
    private final int code;
    private final String msg;
}
