package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum RoleEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Type {
        PLATFORM(1, "平台"),
        OWNER(2, "货主"),
        DRIVER(3, "司机"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<Type> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(Type::getMsg).orElse(null);
        }
    }


}
